/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.RelaxedNameConfig;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.ApplicationYamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;

public class ApplicationYamlAssistContextProvider
implements YamlAssistContextProvider {
    private final SpringPropertyIndexProvider indexProvider;
    private final PropertyCompletionFactory completionFactory;
    private final TypeUtilProvider typeUtilProvider;
    private final RelaxedNameConfig relaxedNameConfig;

    public ApplicationYamlAssistContextProvider(SpringPropertyIndexProvider indexProvider, TypeUtilProvider typeUtilProvider, RelaxedNameConfig relaxedNameConfig, DocumentContextFinder documentContextFinder) {
        this.indexProvider = indexProvider;
        this.completionFactory = new PropertyCompletionFactory(documentContextFinder);
        this.typeUtilProvider = typeUtilProvider;
        this.relaxedNameConfig = relaxedNameConfig;
    }

    public YamlAssistContext getGlobalAssistContext(YamlDocument ydoc) {
        IDocument doc = ydoc.getDocument();
        FuzzyMap index = this.indexProvider.getIndex(doc);
        return ApplicationYamlAssistContext.global((FuzzyMap<PropertyInfo>)index, this.completionFactory, this.typeUtilProvider.getTypeUtil(doc), this.relaxedNameConfig);
    }
}

