/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.RelaxedNameConfig;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.ApplicationYamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.YamlCompletionEngine;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;

public class ApplicationYamlCompletionEngine {
    public static YamlCompletionEngine create(final SpringPropertyIndexProvider indexProvider, DocumentContextFinder documentContextFinder, YamlStructureProvider structureProvider, final TypeUtilProvider typeUtilProvider, final RelaxedNameConfig conf) {
        final PropertyCompletionFactory completionFactory = new PropertyCompletionFactory(documentContextFinder);
        YamlAssistContextProvider contextProvider = new YamlAssistContextProvider(){

            public YamlAssistContext getGlobalAssistContext(YamlDocument ydoc) {
                IDocument doc = ydoc.getDocument();
                FuzzyMap index = indexProvider.getIndex(doc);
                return ApplicationYamlAssistContext.global((FuzzyMap<PropertyInfo>)index, completionFactory, typeUtilProvider.getTypeUtil(doc), conf);
            }
        };
        return new YamlCompletionEngine(structureProvider, contextProvider);
    }
}

