/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.ReplaceDeprecatedYamlQuickfix;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeRef;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlASTReconciler;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class ApplicationYamlASTReconciler
implements YamlASTReconciler {
    private final IProblemCollector problems;
    private final TypeUtil typeUtil;
    private final IndexNavigator nav;

    public ApplicationYamlASTReconciler(IProblemCollector problems, IndexNavigator nav, TypeUtil typeUtil) {
        this.problems = problems;
        this.typeUtil = typeUtil;
        this.nav = nav;
    }

    public void reconcile(YamlFileAST ast, IProgressMonitor mon) {
        this.reconcile(ast, this.nav, mon);
    }

    protected void reconcile(YamlFileAST ast, IndexNavigator nav, IProgressMonitor mon) {
        List nodes = ast.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            mon.beginTask("Reconcile", nodes.size());
            try {
                for (Node node : nodes) {
                    this.reconcile(node, nav);
                    mon.worked(1);
                }
            }
            finally {
                mon.done();
            }
        }
    }

    protected void reconcile(Node node, IndexNavigator nav) {
        switch (node.getNodeId()) {
            case mapping: {
                this.checkForDuplicateKeys((MappingNode)node);
                for (NodeTuple entry : ((MappingNode)node).getValue()) {
                    this.reconcile(entry, nav);
                }
                break;
            }
            case scalar: {
                if (this.isIgnoreScalarAssignmentTo(nav.getPrefix())) break;
                this.expectMapping(node);
                break;
            }
            default: {
                this.expectMapping(node);
            }
        }
    }

    private void checkForDuplicateKeys(MappingNode node) {
        HashSet<String> duplicateKeys = new HashSet<String>();
        HashSet<String> seenKeys = new HashSet<String>();
        for (NodeTuple entry : node.getValue()) {
            String key = NodeUtil.asScalar((Node)entry.getKeyNode());
            if (key == null || seenKeys.add(key)) continue;
            duplicateKeys.add(key);
        }
        if (!duplicateKeys.isEmpty()) {
            for (NodeTuple entry : node.getValue()) {
                Node keyNode = entry.getKeyNode();
                String key = NodeUtil.asScalar((Node)keyNode);
                if (key == null || !duplicateKeys.contains(key)) continue;
                this.problems.accept((ReconcileProblem)this.problem(SpringPropertiesProblemType.YAML_DUPLICATE_KEY, keyNode, "Duplicate key '" + key + "'"));
            }
        }
    }

    protected boolean isIgnoreScalarAssignmentTo(String propName) {
        return propName != null && propName.equals("spring.profiles");
    }

    private void reconcile(NodeTuple entry, IndexNavigator nav) {
        Node keyNode = entry.getKeyNode();
        String key = NodeUtil.asScalar((Node)keyNode);
        if (key == null) {
            this.expectScalar(keyNode);
        } else {
            IndexNavigator subNav = nav.selectSubProperty(key);
            PropertyInfo match = subNav.getExactMatch();
            PropertyInfo extension = subNav.getExtensionCandidate();
            if (match == null && extension == null) {
                String keyAlias = StringUtil.camelCaseToHyphens((String)key);
                IndexNavigator subNavAlias = nav.selectSubProperty(keyAlias);
                match = subNavAlias.getExactMatch();
                extension = subNavAlias.getExtensionCandidate();
                if (match != null || extension != null) {
                    subNav = subNavAlias;
                }
            }
            if (match != null && extension != null) {
                return;
            }
            if (match != null) {
                Type type = TypeParser.parse((String)match.getType());
                if (match.isDeprecated()) {
                    this.deprecatedProperty(match, keyNode);
                }
                this.reconcile(entry.getValueNode(), type);
            } else if (extension != null) {
                Node valueNode = entry.getValueNode();
                this.reconcile(valueNode, subNav);
            } else {
                this.unkownProperty(keyNode, subNav.getPrefix(), entry);
            }
        }
    }

    private void reconcile(Node node, Type type) {
        if (type != null) {
            switch (node.getNodeId()) {
                case scalar: {
                    this.reconcile((ScalarNode)node, type);
                    break;
                }
                case sequence: {
                    this.reconcile((SequenceNode)node, type);
                    break;
                }
                case mapping: {
                    this.reconcile((MappingNode)node, type);
                    break;
                }
                case anchor: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing switch case");
                }
            }
        }
    }

    private void reconcile(MappingNode mapping, Type type) {
        block13: {
            block14: {
                block12: {
                    this.checkForDuplicateKeys(mapping);
                    if (!this.typeUtil.isAtomic(type)) break block12;
                    this.expectTypeFoundMapping(type, mapping);
                    break block13;
                }
                if (!TypeUtil.isMap((Type)type) && !TypeUtil.isSequencable((Type)type)) break block14;
                Type keyType = this.typeUtil.getKeyType(type);
                Type valueType = TypeUtil.getDomainType((Type)type);
                if (keyType != null) {
                    for (NodeTuple entry : mapping.getValue()) {
                        this.reconcile(entry.getKeyNode(), keyType);
                    }
                }
                if (valueType == null) break block13;
                for (NodeTuple entry : mapping.getValue()) {
                    Node value = entry.getValueNode();
                    Type nestedValueType = valueType;
                    if (value.getNodeId() == NodeId.mapping) {
                        if (TypeUtil.isObject((Type)valueType)) {
                            nestedValueType = type;
                        } else if (TypeUtil.isString((Type)keyType) && this.typeUtil.isAtomic(valueType)) {
                            nestedValueType = type;
                        }
                    }
                    this.reconcile(entry.getValueNode(), nestedValueType);
                }
                break block13;
            }
            Map props = this.typeUtil.getPropertiesMap(type, TypeUtil.EnumCaseMode.ALIASED, TypeUtil.BeanPropertyNameMode.ALIASED);
            if (props != null) {
                for (NodeTuple entry : mapping.getValue()) {
                    Node keyNode = entry.getKeyNode();
                    String key = NodeUtil.asScalar((Node)keyNode);
                    if (key == null) {
                        this.expectBeanPropertyName(keyNode, type);
                        continue;
                    }
                    if (!props.containsKey(key)) {
                        this.unknownBeanProperty(keyNode, type, key);
                        continue;
                    }
                    Node valNode = entry.getValueNode();
                    TypedProperty typedProperty = (TypedProperty)props.get(key);
                    if (typedProperty == null) continue;
                    if (typedProperty.isDeprecated()) {
                        this.deprecatedProperty(type, typedProperty, keyNode);
                    }
                    this.reconcile(valNode, typedProperty.getType());
                }
            }
        }
    }

    private void reconcile(SequenceNode seq, Type type) {
        if (this.typeUtil.isAtomic(type)) {
            this.expectTypeFoundSequence(type, seq);
        } else if (TypeUtil.isSequencable((Type)type)) {
            Type domainType = TypeUtil.getDomainType((Type)type);
            if (domainType != null) {
                for (Node element : seq.getValue()) {
                    this.reconcile(element, domainType);
                }
            }
        } else {
            this.expectTypeFoundSequence(type, seq);
        }
    }

    private void reconcile(ScalarNode scalar, Type type) {
        ValueParser valueParser;
        String stringValue = scalar.getValue();
        if (!stringValue.contains("${") && (valueParser = this.typeUtil.getValueParser(type)) != null) {
            try {
                valueParser.parse(stringValue);
            }
            catch (Exception exception) {
                this.valueTypeMismatch(type, scalar);
            }
        }
    }

    private void expectTypeFoundMapping(Type type, MappingNode node) {
        this.expectType(SpringPropertiesProblemType.YAML_EXPECT_TYPE_FOUND_MAPPING, type, (Node)node);
    }

    private void expectTypeFoundSequence(Type type, SequenceNode seq) {
        this.expectType(SpringPropertiesProblemType.YAML_EXPECT_TYPE_FOUND_SEQUENCE, type, (Node)seq);
    }

    private void valueTypeMismatch(Type type, ScalarNode scalar) {
        this.expectType(SpringPropertiesProblemType.YAML_VALUE_TYPE_MISMATCH, type, (Node)scalar);
    }

    private void unkownProperty(Node node, String name, NodeTuple entry) {
        SpringPropertyProblem p = this.problem(SpringPropertiesProblemType.YAML_UNKNOWN_PROPERTY, node, "Unknown property '" + name + "'");
        p.setPropertyName(this.extendForQuickfix(StringUtil.camelCaseToHyphens((String)name), entry.getValueNode()));
        this.problems.accept((ReconcileProblem)p);
    }

    private String extendForQuickfix(String name, Node node) {
        String extra;
        NodeRef.TupleValueRef child;
        if (node != null && (child = this.getFirstTupleValue(YamlFileAST.getChildren((Node)node))) != null && (extra = NodeUtil.asScalar((Node)child.getKey())) != null) {
            return this.extendForQuickfix(String.valueOf(name) + "." + StringUtil.camelCaseToHyphens((String)extra), child.get());
        }
        return name;
    }

    private NodeRef.TupleValueRef getFirstTupleValue(List<NodeRef<?>> children) {
        for (NodeRef<?> nodeRef : children) {
            if (nodeRef.getKind() != NodeRef.Kind.VAL) continue;
            return (NodeRef.TupleValueRef)nodeRef;
        }
        return null;
    }

    private void expectScalar(Node node) {
        this.problems.accept((ReconcileProblem)this.problem(SpringPropertiesProblemType.YAML_EXPECT_SCALAR, node, "Expecting a 'Scalar' node but got " + this.describe(node)));
    }

    protected void expectMapping(Node node) {
        this.problems.accept((ReconcileProblem)this.problem(SpringPropertiesProblemType.YAML_EXPECT_MAPPING, node, "Expecting a 'Mapping' node but got " + this.describe(node)));
    }

    private void expectBeanPropertyName(Node keyNode, Type type) {
        this.problems.accept((ReconcileProblem)this.problem(SpringPropertiesProblemType.YAML_EXPECT_BEAN_PROPERTY_NAME, keyNode, "Expecting a bean-property name for object of type '" + this.typeUtil.niceTypeName(type) + "' " + "but got " + this.describe(keyNode)));
    }

    private void unknownBeanProperty(Node keyNode, Type type, String name) {
        this.problems.accept((ReconcileProblem)this.problem(SpringPropertiesProblemType.YAML_INVALID_BEAN_PROPERTY, keyNode, "Unknown property '" + name + "' for type '" + this.typeUtil.niceTypeName(type) + "'"));
    }

    private void expectType(SpringPropertiesProblemType problemType, Type type, Node node) {
        this.problems.accept((ReconcileProblem)this.problem(problemType, node, "Expecting a '" + this.typeUtil.niceTypeName(type) + "' but got " + this.describe(node)));
    }

    private void deprecatedProperty(PropertyInfo property, Node keyNode) {
        SpringPropertyProblem problem = this.deprecatedPropertyProblem(property.getId(), null, keyNode, property.getDeprecationReplacement(), property.getDeprecationReason());
        problem.setMetadata(property);
        problem.setProblemFixer(ReplaceDeprecatedYamlQuickfix.FIXER);
        this.problems.accept((ReconcileProblem)problem);
    }

    private void deprecatedProperty(Type contextType, TypedProperty property, Node keyNode) {
        SpringPropertyProblem problem = this.deprecatedPropertyProblem(property.getName(), this.typeUtil.niceTypeName(contextType), keyNode, property.getDeprecationReplacement(), property.getDeprecationReason());
        this.problems.accept((ReconcileProblem)problem);
    }

    protected SpringPropertyProblem deprecatedPropertyProblem(String name, String contextType, Node keyNode, String replace, String reason) {
        SpringPropertyProblem problem = this.problem(SpringPropertiesProblemType.YAML_DEPRECATED, keyNode, TypeUtil.deprecatedPropertyMessage((String)name, (String)contextType, (String)replace, (String)reason));
        problem.setPropertyName(name);
        return problem;
    }

    protected SpringPropertyProblem problem(SpringPropertiesProblemType type, Node node, String msg) {
        int start = node.getStartMark().getIndex();
        int end = node.getEndMark().getIndex();
        return SpringPropertyProblem.problem((SpringPropertiesProblemType)type, (String)msg, (int)start, (int)(end - start));
    }

    private String describe(Node node) {
        switch (node.getNodeId()) {
            case scalar: {
                return "'" + ((ScalarNode)node).getValue() + "'";
            }
            case mapping: {
                return "a 'Mapping' node";
            }
            case sequence: {
                return "a 'Sequence' node";
            }
            case anchor: {
                return "a 'Anchor' node";
            }
        }
        throw new IllegalStateException("Missing switch case");
    }
}

