/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.ApplicationYamlASTReconciler;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlASTReconciler;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlReconcileEngine;

public class ApplicationYamlReconcileEngine
extends YamlReconcileEngine {
    private SpringPropertyIndexProvider indexProvider;
    private TypeUtilProvider typeUtilProvider;

    public ApplicationYamlReconcileEngine(YamlASTProvider astProvider, SpringPropertyIndexProvider indexProvider, TypeUtilProvider typeUtilProvider) {
        super(astProvider);
        this.indexProvider = indexProvider;
        this.typeUtilProvider = typeUtilProvider;
    }

    protected YamlASTReconciler getASTReconciler(IDocument doc, IProblemCollector problemCollector) {
        FuzzyMap index = this.indexProvider.getIndex(doc);
        if (index != null && !index.isEmpty()) {
            IndexNavigator nav = IndexNavigator.with((FuzzyMap<PropertyInfo>)index);
            return new ApplicationYamlASTReconciler(problemCollector, nav, this.typeUtilProvider.getTypeUtil(doc));
        }
        return null;
    }

    protected ReconcileProblem syntaxError(String msg, int offset, int len) {
        return SpringPropertyProblem.problem((SpringPropertiesProblemType)SpringPropertiesProblemType.YAML_SYNTAX_ERROR, (String)msg, (int)offset, (int)len);
    }
}

