/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.properties.editor.completions.LazyProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.ProblemFixer;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.completions.DocumentEdits;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlPathEdits;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;

public class ReplaceDeprecatedYamlQuickfix
implements ICompletionProposal {
    public static ProblemFixer FIXER = (context, problem, proposals) -> {
        String replacement;
        PropertyInfo metadata = problem.getMetadata();
        if (metadata != null && (replacement = metadata.getDeprecationReplacement()) != null) {
            proposals.add(new ReplaceDeprecatedYamlQuickfix(context, problem));
        }
    };
    private final QuickfixContext context;
    private final SpringPropertyProblem problem;
    private LazyProposalApplier applier = new LazyProposalApplier(){

        protected ProposalApplier create() throws Exception {
            YamlStructureParser.SKeyNode problemKey;
            YamlPath oldPath;
            String newName = ReplaceDeprecatedYamlQuickfix.this.problem.getMetadata().getDeprecationReplacement();
            String oldName = ReplaceDeprecatedYamlQuickfix.this.problem.getPropertyName();
            YamlPath newPath = YamlPath.fromProperty((String)newName);
            YamlPath prefix = newPath.commonPrefix(oldPath = YamlPath.fromProperty((String)oldName));
            if (prefix.size() == newPath.size() - 1 && newPath.size() == oldPath.size()) {
                DocumentEdits edits = new DocumentEdits(ReplaceDeprecatedYamlQuickfix.this.context.getDocument());
                edits.replace(ReplaceDeprecatedYamlQuickfix.this.problem.getOffset(), ReplaceDeprecatedYamlQuickfix.this.problem.getEnd(), newPath.getLastSegment().toPropString());
                return edits;
            }
            YamlDocument doc = new YamlDocument(ReplaceDeprecatedYamlQuickfix.this.context.getDocument(), YamlStructureProvider.DEFAULT);
            YamlStructureParser.SNode problemNode = doc.getStructure().find(ReplaceDeprecatedYamlQuickfix.this.problem.getOffset());
            if (problemNode.getNodeType() == YamlStructureParser.SNodeType.KEY && (problemKey = (YamlStructureParser.SKeyNode)problemNode).isInKey(ReplaceDeprecatedYamlQuickfix.this.problem.getOffset())) {
                YamlPathEdits edits = new YamlPathEdits(doc);
                String valueText = problemKey.getValueWithRelativeIndent();
                edits.deleteNode((YamlStructureParser.SNode)problemKey);
                int maxParentDeletions = oldPath.size() - prefix.size() - 1;
                YamlStructureParser.SChildBearingNode parent = problemNode.getParent();
                while (maxParentDeletions > 0 && parent != null && parent.getChildren().size() == 1) {
                    edits.deleteNode((YamlStructureParser.SNode)parent);
                    parent = parent.getParent();
                    --maxParentDeletions;
                }
                YamlStructureParser.SDocNode docRoot = problemNode.getDocNode();
                edits.createPath((YamlStructureParser.SChildBearingNode)docRoot, YamlPath.fromProperty((String)newName), valueText);
                return edits;
            }
            ReplaceDeprecatedYamlQuickfix.this.context.getUI().error("Yaml file too complex", "Sorry, but the yaml file is too complex for this quickfix. Please make the change manually.");
            return ProposalApplier.NULL;
        }
    };

    public ReplaceDeprecatedYamlQuickfix(QuickfixContext context, SpringPropertyProblem problem) {
        this.context = context;
        this.problem = problem;
    }

    public void apply(IDocument doc) {
        try {
            this.applier.apply(doc);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private String getReplacementProperty() {
        return this.problem.getMetadata().getDeprecationReplacement();
    }

    public Point getSelection(IDocument doc) {
        try {
            return this.applier.getSelection(doc);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "Change to '" + this.getReplacementProperty() + "'";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

