/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigFactory;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

public class PropertiesConfigSet
extends BeansConfigSet {
    public PropertiesConfigSet(PropertiesProject project, String name, IBeansConfigSet.Type type) {
        super((IBeansProject)project, name, new HashSet(), type);
    }

    public PropertiesConfigSet(PropertiesProject project, IBeansConfigSet configSet, IBeansConfigSet.Type type) {
        super((IBeansProject)project, configSet.getElementName(), configSet.getConfigNames(), type);
        super.setAllowAliasOverriding(configSet.isAllowAliasOverriding());
        super.setAllowBeanDefinitionOverriding(configSet.isAllowBeanDefinitionOverriding());
        super.setIncomplete(configSet.isIncomplete());
        super.setProfiles(configSet.getProfiles());
    }

    public void setElementName(String name) {
        super.setElementName(name);
        this.notifyListeners();
    }

    public void setProfiles(Set<String> profiles) {
        super.setProfiles(profiles);
        this.notifyListeners();
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        super.setAllowBeanDefinitionOverriding(allowBeanDefinitionOverriding);
        this.notifyListeners();
    }

    public void setIncomplete(boolean isIncomplete) {
        super.setIncomplete(isIncomplete);
        this.notifyListeners();
    }

    public void addConfig(String configName) {
        super.addConfig(configName);
        this.notifyListeners();
    }

    public void removeConfig(String configName) {
        super.removeConfig(configName);
        this.notifyListeners();
    }

    public void removeAllConfigs() {
        super.removeAllConfigs();
        this.notifyListeners();
    }

    public Set<IBeansConfig> getConfigs() {
        LinkedHashSet<IBeansConfig> configs = new LinkedHashSet<IBeansConfig>();
        for (String configName : this.configNames) {
            IBeansConfig config = PropertiesConfigFactory.create(this, configName, IBeansConfig.Type.MANUAL);
            if (config == null) continue;
            configs.add(config);
        }
        return configs;
    }

    public void moveConfigUp(IBeansConfig config) {
        ArrayList<String> newConfigNames;
        int index;
        String configName = config.getElementName();
        if (this.configNames.contains(configName) && (index = (newConfigNames = new ArrayList<String>(this.configNames)).indexOf(configName)) > 0) {
            newConfigNames.remove(configName);
            newConfigNames.add(index - 1, configName);
            this.configNames.clear();
            this.configNames.addAll(newConfigNames);
            this.notifyListeners();
        }
    }

    public void moveConfigDown(IBeansConfig config) {
        ArrayList<String> newConfigNames;
        int index;
        String configName = config.getElementName();
        if (this.configNames.contains(configName) && (index = (newConfigNames = new ArrayList<String>(this.configNames)).indexOf(configName)) < this.configNames.size() - 1) {
            newConfigNames.remove(configName);
            newConfigNames.add(index + 1, configName);
            this.configNames.clear();
            this.configNames.addAll(newConfigNames);
            this.notifyListeners();
        }
    }

    protected final void notifyListeners() {
        PropertiesModel model = (PropertiesModel)this.getElementParent().getElementParent();
        model.notifyListeners((IModelElement)this, ModelChangeEvent.Type.CHANGED);
    }
}

