/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.wizards.BeansWizardsMessages;

public class NamespaceSelectionWizardPage
extends WizardPage {
    private static final int XSD_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private CheckboxTableViewer xsdViewer;
    private CheckboxTableViewer versionViewer;
    private Map<INamespaceDefinition, String> selectedVersion = new HashMap<INamespaceDefinition, String>();
    private INamespaceDefinition selectedNamespaceDefinition;
    private IPath filePath;

    protected NamespaceSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(BeansWizardsMessages.NewConfig_title);
        this.setDescription(BeansWizardsMessages.NewConfig_xsdDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        Label namespaceLabel = new Label(composite, 0);
        namespaceLabel.setText("Select desired XSD namespace declarations:");
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.xsdViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.xsdViewer.getTable().setLayoutData((Object)gd);
        this.xsdViewer.setContentProvider((IContentProvider)new XsdConfigContentProvider());
        this.xsdViewer.setLabelProvider((IBaseLabelProvider)new XsdLabelProvider());
        this.xsdViewer.setInput((Object)this);
        INamespaceDefinition defaultDefinition = NamespaceUtils.getDefaultNamespaceDefinition();
        if (defaultDefinition != null) {
            this.xsdViewer.setGrayedElements(new Object[]{defaultDefinition});
            this.xsdViewer.setCheckedElements(new Object[]{defaultDefinition});
        }
        this.xsdViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    NamespaceSelectionWizardPage.this.selectedNamespaceDefinition = (INamespaceDefinition)obj;
                    NamespaceSelectionWizardPage.this.versionViewer.setInput(obj);
                    if (NamespaceSelectionWizardPage.this.selectedVersion.containsKey(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)) {
                        NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{NamespaceSelectionWizardPage.this.selectedVersion.get(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)});
                    }
                    if (NamespaceSelectionWizardPage.this.xsdViewer.getChecked(obj) && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition.getSchemaLocations().size() > 0) {
                        NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(true);
                    } else {
                        NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(false);
                    }
                }
            }
        });
        this.xsdViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                NamespaceSelectionWizardPage.this.selectedNamespaceDefinition = (INamespaceDefinition)obj;
                NamespaceSelectionWizardPage.this.versionViewer.setInput(obj);
                if (NamespaceSelectionWizardPage.this.selectedVersion.containsKey(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)) {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{NamespaceSelectionWizardPage.this.selectedVersion.get(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)});
                }
                if (event.getChecked() && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition != null && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition.getSchemaLocations().size() > 0) {
                    NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(true);
                } else {
                    NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(false);
                }
            }
        });
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText("Select desired XSD (if none is selected the default will be used):");
        this.versionViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.versionViewer.getTable().setLayoutData((Object)gd);
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setSorter(new ViewerSorter());
        this.versionViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{event.getElement()});
                    if (NamespaceSelectionWizardPage.this.selectedNamespaceDefinition != null) {
                        NamespaceSelectionWizardPage.this.selectedVersion.put(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition, (String)event.getElement());
                    }
                } else {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[0]);
                    NamespaceSelectionWizardPage.this.selectedVersion.remove(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition);
                }
            }
        });
    }

    public List<INamespaceDefinition> getXmlSchemaDefinitions() {
        ArrayList<INamespaceDefinition> defs = new ArrayList<INamespaceDefinition>();
        Object[] checkedElements = this.xsdViewer.getCheckedElements();
        if (checkedElements != null) {
            int i = 0;
            while (i < checkedElements.length) {
                defs.add((INamespaceDefinition)checkedElements[i]);
                ++i;
            }
        }
        return defs;
    }

    public Map<INamespaceDefinition, String> getSchemaVersions() {
        return this.selectedVersion;
    }

    public void setFilePath(IPath filePath) {
        this.filePath = filePath;
        if (this.xsdViewer != null) {
            this.xsdViewer.setInput((Object)this);
        }
    }

    private class VersionContentProvider
    implements IStructuredContentProvider {
        private VersionContentProvider() {
        }

        public Object[] getElements(Object obj) {
            if (obj instanceof INamespaceDefinition) {
                return ((INamespaceDefinition)obj).getSchemaLocations().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class VersionLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }
    }

    private class XsdConfigContentProvider
    implements IStructuredContentProvider {
        private List<INamespaceDefinition> namespaceDefinitionList = new ArrayList<INamespaceDefinition>();
        private boolean loading = false;
        private IProject activeProject = null;

        private XsdConfigContentProvider() {
        }

        public Object[] getElements(Object obj) {
            IProject project = null;
            if (NamespaceSelectionWizardPage.this.filePath != null && NamespaceSelectionWizardPage.this.filePath.segmentCount() > 0) {
                String projectName = NamespaceSelectionWizardPage.this.filePath.segment(0);
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if (this.activeProject == null && project != null || this.activeProject != null && !this.activeProject.equals(project)) {
                this.namespaceDefinitionList = new ArrayList<INamespaceDefinition>();
                this.loading = false;
            }
            if (this.namespaceDefinitionList.size() == 0 && !this.loading) {
                this.activeProject = project;
                NamespaceUtils.getNamespaceDefinitions(project, new NamespaceUtils.INamespaceDefinitionTemplate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doWithNamespaceDefinitions(INamespaceDefinition[] namespaceDefinitions, IProject project) {
                        if (project == null || project != null && project.equals((Object)XsdConfigContentProvider.this.activeProject)) {
                            INamespaceDefinition[] iNamespaceDefinitionArray = namespaceDefinitions;
                            int n = namespaceDefinitions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                INamespaceDefinition namespaceDefinition = iNamespaceDefinitionArray[n2];
                                List list = XsdConfigContentProvider.this.namespaceDefinitionList;
                                synchronized (list) {
                                    if (!XsdConfigContentProvider.this.namespaceDefinitionList.contains(namespaceDefinition)) {
                                        XsdConfigContentProvider.this.namespaceDefinitionList.add(namespaceDefinition);
                                    }
                                }
                                ++n2;
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!NamespaceSelectionWizardPage.this.xsdViewer.getControl().isDisposed()) {
                                        NamespaceSelectionWizardPage.this.xsdViewer.setInput((Object)this);
                                    }
                                }
                            });
                        }
                        XsdConfigContentProvider.this.loading = false;
                    }
                });
            }
            return this.namespaceDefinitionList.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class XsdLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return xsdDef.getNamespaceImage();
            }
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return String.valueOf(xsdDef.getDefaultNamespacePrefix()) + " - " + xsdDef.getNamespaceURI();
            }
            return "";
        }
    }
}

