/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.wizards.BeansWizardsMessages;
import org.springframework.ide.eclipse.beans.ui.wizards.LinkToBeansConfigSetWizardPage;
import org.springframework.ide.eclipse.beans.ui.wizards.NamespaceSelectionWizardPage;
import org.springframework.ide.eclipse.beans.ui.wizards.NewBeansConfigFilePage;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.util.StringUtils;

public class NewBeansConfigWizard
extends Wizard
implements INewWizard {
    private NewBeansConfigFilePage mainPage;
    private LinkToBeansConfigSetWizardPage linkPage;
    private NamespaceSelectionWizardPage xsdPage;
    private IStructuredSelection selection;
    private IBeansConfig newConfig;

    public NewBeansConfigWizard() {
        this.setDialogSettings(BeansUIPlugin.getDefault().getDialogSettings());
    }

    public IBeansConfig getNewConfig() {
        return this.newConfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(BeansWizardsMessages.NewConfig_windowTitle);
        this.setDefaultPageImageDescriptor(BeansUIImages.DESC_WIZ_CONFIG);
    }

    public void addPages() {
        super.addPages();
        this.xsdPage = new NamespaceSelectionWizardPage("xsdPage");
        this.mainPage = new NewBeansConfigFilePage("beansNewConfigPage", this.selection, this.xsdPage);
        this.linkPage = new LinkToBeansConfigSetWizardPage("beansLinkConfigPage");
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.xsdPage);
        this.addPage((IWizardPage)this.linkPage);
    }

    public boolean performFinish() {
        this.createNewConfig();
        if (this.newConfig == null) {
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)this.newConfig.getElementResource(), (IWorkbenchWindow)BeansUIPlugin.getActiveWorkbenchWindow());
        SpringUIUtils.openInEditor((IFile)((IFile)this.newConfig.getElementResource()), (int)-1);
        return true;
    }

    private void createNewConfig() {
        IFile file;
        BeansProject beansProject;
        this.mainPage.setXmlSchemaDefinitions(this.xsdPage.getXmlSchemaDefinitions());
        this.mainPage.setSchemaVersions(this.xsdPage.getSchemaVersions());
        if (!StringUtils.hasText((String)this.mainPage.getFileExtension())) {
            Set suffixes;
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.mainPage.getContainerFullPath());
            this.mainPage.setFileExtension("xml");
            beansProject = this.getProject(resource);
            if (beansProject != null && !(suffixes = beansProject.getConfigSuffixes()).isEmpty()) {
                this.mainPage.setFileExtension((String)suffixes.iterator().next());
            }
        }
        if ((beansProject = this.getProject((IResource)(file = this.mainPage.createNewFile()))) == null) {
            WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    SpringCoreUtils.addProjectNature((IProject)file.getProject(), (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)monitor);
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)oper);
            }
            catch (InvocationTargetException e) {
                SpringCore.log((Throwable)e);
            }
            catch (InterruptedException e) {
                SpringCore.log((Throwable)e);
            }
            beansProject = new BeansProject(BeansCorePlugin.getModel(), file.getProject());
        }
        if (beansProject != null) {
            beansProject.addConfig(file, IBeansConfig.Type.MANUAL);
            this.newConfig = beansProject.getConfig(file);
            Set<IBeansConfigSet> configSets = this.linkPage.getBeansConfigSets();
            for (IBeansConfigSet bcs : configSets) {
                if (!beansProject.equals((Object)bcs.getElementParent())) continue;
                ((BeansConfigSet)bcs).addConfig(this.newConfig.getElementName());
            }
            beansProject.saveDescription();
            BeansModelLabelDecorator.update();
        }
    }

    private BeansProject getProject(IResource file) {
        return (BeansProject)BeansCorePlugin.getModel().getProject(file.getProject());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }
}

