/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.outline.OutlineSorter;

public class OutlineStyleAction
extends Action {
    private static final String PREFIX = "Outline.SpringStyle.";
    private TreeViewer viewer;

    public OutlineStyleAction(TreeViewer viewer) {
        super(Activator.getResourceString("Outline.SpringStyle.label"), 2);
        this.viewer = viewer;
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        boolean checked = prefs.getBoolean("org.springframework.ide.eclipse.beans.ui.editor.outline.spring");
        this.update(checked, false);
        this.setImageDescriptor(BeansUIImages.DESC_OBJS_SPRING);
    }

    public void run() {
        this.update(this.isChecked(), true);
    }

    public void update(boolean value, boolean doStore) {
        this.setChecked(value);
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        boolean sort = prefs.getBoolean("org.springframework.ide.eclipse.beans.ui.editor.outline.sort");
        if (sort) {
            this.viewer.setSorter((ViewerSorter)(value ? new OutlineSorter() : null));
        }
        this.setToolTipText(value ? Activator.getResourceString("Outline.SpringStyle.tooltip.checked") : Activator.getResourceString("Outline.SpringStyle.tooltip.unchecked"));
        this.setDescription(value ? Activator.getResourceString("Outline.SpringStyle.description.checked") : Activator.getResourceString("Outline.SpringStyle.description.unchecked"));
        if (doStore) {
            prefs.setValue("org.springframework.ide.eclipse.beans.ui.editor.outline.spring", value);
            Activator.getDefault().savePluginPreferences();
            this.viewer.refresh();
        }
    }
}

