/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.beans.Introspector;
import java.io.Serializable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.util.ClassUtils;

public abstract class AbstractIdContentAssistCalculator
implements IContentAssistCalculator {
    private static final String[] FILTERED_NAMES = new String[]{Serializable.class.getName(), InitializingBean.class.getName(), FactoryBean.class.getName(), DisposableBean.class.getName()};

    protected void createBeanIdProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, String className) {
        String beanId = this.buildDefaultBeanName(className);
        if (beanId.startsWith(context.getMatchString()) && this.shouldNotFilter(className)) {
            recorder.recordProposal(BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif"), 10, String.valueOf(beanId) + " - " + className, beanId);
        }
    }

    private String buildDefaultBeanName(String className) {
        String shortClassName = className;
        int ix = className.lastIndexOf(36);
        shortClassName = ix >= 0 ? className.substring(ix + 1) : ClassUtils.getShortName((String)className);
        return Introspector.decapitalize(shortClassName);
    }

    private boolean shouldNotFilter(String className) {
        String[] stringArray = FILTERED_NAMES;
        int n = FILTERED_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (className.startsWith(filter)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

