/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.MethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.FlagsMethodFilter;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FactoryMethodContentAssistCalculator
implements IContentAssistCalculator {
    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        boolean isStatic;
        Node node = context.getNode();
        NamedNodeMap attributes = node.getAttributes();
        Node factoryBean = this.getFactoryBeanReferenceNode(attributes);
        String factoryClassName = null;
        if (factoryBean != null) {
            factoryClassName = BeansEditorUtils.getClassNameForBean(context.getFile(), context.getDocument(), factoryBean.getNodeValue());
            isStatic = false;
        } else {
            factoryClassName = BeansEditorUtils.getAttribute(node, "class");
            isStatic = true;
        }
        if (factoryClassName != null) {
            this.addFactoryMethodAttributeValueProposals(recorder, context, factoryClassName, isStatic);
        }
    }

    protected Node getFactoryBeanReferenceNode(NamedNodeMap attributes) {
        return attributes.getNamedItem("factory-bean");
    }

    private void addFactoryMethodAttributeValueProposals(IContentAssistProposalRecorder recorder, IContentAssistContext context, final String factoryClassName, boolean isStatic) {
        final IFile file = context.getFile();
        FlagsMethodFilter filter = null;
        filter = isStatic ? new FlagsMethodFilter(53504) : new FlagsMethodFilter(20736);
        MethodContentAssistCalculator calculator = new MethodContentAssistCalculator((IMethodFilter)filter){

            @Override
            public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
                super.computeProposals(context, recorder);
                IType type = this.calculateType(context);
                try {
                    IFile contextFile;
                    if (type != null && type.isEnum() && (contextFile = context.getFile()) != null && contextFile.exists()) {
                        IType enumType = JdtUtils.getJavaType((IProject)context.getFile().getProject(), (String)Enum.class.getName());
                        HashSet<String> proposedMethods = new HashSet<String>();
                        for (IMethod method : Introspector.findAllMethods((IType)enumType, (String)context.getMatchString(), (IMethodFilter)this.filter)) {
                            if (proposedMethods.contains(method.getElementName())) continue;
                            proposedMethods.add(method.getElementName());
                            this.createMethodProposal(recorder, method);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }

            @Override
            protected IType calculateType(IContentAssistContext context) {
                if (file != null && file.exists()) {
                    return JdtUtils.getJavaType((IProject)file.getProject(), (String)factoryClassName);
                }
                return null;
            }
        };
        calculator.computeProposals(context, recorder);
    }
}

