/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.AbstractHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NamespaceHyperlinkDetectorSupport;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ToolAnnotationBasedHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DelegatingHyperlinkDetector
implements IHyperlinkDetector {
    private static final NamespaceHyperlinkDetectorSupport DEFAULT_DETECTOR = new NamespaceHyperlinkDetectorSupport();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<Object> hyperlinks = new ArrayList<IHyperlink>();
        IDocument document = textViewer.getDocument();
        Node currentNode = BeansEditorUtils.getNodeByOffset(document, region.getOffset());
        this.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks, hyperlinks, currentNode);
        if (hyperlinks.size() == 0 || canShowMultipleHyperlinks) {
            this.detectAnnotationBasedHyperlinks(textViewer, region, canShowMultipleHyperlinks, hyperlinks, currentNode);
        }
        ArrayList<IHyperlink> safeHylerlinks = new ArrayList<IHyperlink>();
        for (IHyperlink iHyperlink : hyperlinks) {
            if (iHyperlink == null) continue;
            safeHylerlinks.add(iHyperlink);
        }
        hyperlinks = safeHylerlinks;
        if (hyperlinks.size() > 0) {
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        return null;
    }

    private void detectAnnotationBasedHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, List<IHyperlink> hyperlinks, Node currentNode) {
        IHyperlink[] detectedHyperlinks;
        ToolAnnotationBasedHyperlinkDetector detector = new ToolAnnotationBasedHyperlinkDetector();
        if (currentNode != null && (detectedHyperlinks = detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks)) != null) {
            hyperlinks.addAll(Arrays.asList(detectedHyperlinks));
        }
    }

    private void detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, List<IHyperlink> hyperlinks, Node currentNode) {
        if (currentNode != null) {
            IHyperlink[] detectedHyperlinks;
            IHyperlinkDetector[] detectors;
            IHyperlinkDetector[] iHyperlinkDetectorArray = detectors = NamespaceUtils.getHyperlinkDetector(currentNode.getNamespaceURI());
            int n = detectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                IHyperlink[] detectedHyperlinks2 = detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
                if (detectedHyperlinks2 != null) {
                    hyperlinks.addAll(Arrays.asList(detectedHyperlinks2));
                }
                ++n2;
            }
            if (detectors.length == 0 && (detectedHyperlinks = DEFAULT_DETECTOR.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks)) != null) {
                hyperlinks.addAll(Arrays.asList(detectedHyperlinks));
            }
        }
    }

    private class ToolAnnotationBasedHyperlinkDetector
    extends AbstractHyperlinkDetector
    implements IHyperlinkDetector {
        private final ToolAnnotationBasedHyperlinkCalculator calculator = new ToolAnnotationBasedHyperlinkCalculator();

        private ToolAnnotationBasedHyperlinkDetector() {
        }

        @Override
        public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
            return this.calculator.createHyperlink(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        }

        @Override
        public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
            return this.calculator.createHyperlinks(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        }

        @Override
        public boolean isLinkableAttr(Attr attr) {
            return true;
        }
    }
}

