/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.outline.bean;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.springframework.ide.eclipse.beans.core.BeansTags;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.outline.BeansContentOutlineConfiguration;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansOutlineLabelProvider
extends JFaceNodeLabelProvider {
    public Image getImage(Object object) {
        Node node = (Node)object;
        String nodeName = node.getLocalName();
        NamedNodeMap attributes = node.getAttributes();
        if ("alias".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.alias_obj.gif");
        }
        if ("import".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.import_obj.gif");
        }
        if ("bean".equals(nodeName)) {
            int flags = 0;
            if (attributes.getNamedItem("parent") != null) {
                flags |= 0x10;
            } else if (attributes.getNamedItem("factory-bean") != null || attributes.getNamedItem("factory-method") != null) {
                flags |= 0x20;
            }
            Image image = BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif");
            return BeansModelImages.getDecoratedImage((Image)image, (int)flags);
        }
        if ("beans".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.config_obj.gif");
        }
        if ("constructor-arg".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.constructor_obj.gif");
        }
        if ("property".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.property_obj.gif");
        }
        if ("lookup-method".equals(nodeName) || "replaced-method".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.method_override_obj.gif");
        }
        if ("list".equals(nodeName) || "set".equals(nodeName) || "map".equals(nodeName) || "props".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.collection_obj.gif");
        }
        if ("ref".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.beanref_obj.gif");
        }
        if ("description".equals(nodeName)) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.description_obj.gif");
        }
        return null;
    }

    public String getText(Object o) {
        Node node = (Node)o;
        NamedNodeMap attrs = node.getAttributes();
        String text = "";
        BeansTags.Tag tag = BeansTags.getTag((Node)node);
        if (tag == BeansTags.Tag.IMPORT) {
            Node attr = attrs.getNamedItem("resource");
            if (attr != null) {
                text = attr.getNodeValue();
            }
        } else if (tag == BeansTags.Tag.ALIAS) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                text = attr.getNodeValue();
            }
            if (BeansContentOutlineConfiguration.isShowAttributes() && (attr = attrs.getNamedItem("alias")) != null) {
                text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
            }
        } else if (tag == BeansTags.Tag.BEANS) {
            text = "beans";
        } else if (tag == BeansTags.Tag.BEAN) {
            boolean hasParent = false;
            Node attr = attrs.getNamedItem("id");
            if (attr != null) {
                text = attr.getNodeValue();
            } else {
                attr = attrs.getNamedItem("name");
                if (attr != null) {
                    text = attr.getNodeValue();
                } else {
                    attr = attrs.getNamedItem("parent");
                    if (attr != null) {
                        text = "<" + attr.getNodeValue() + ">";
                        hasParent = true;
                    }
                }
            }
            if (BeansContentOutlineConfiguration.isShowAttributes()) {
                attr = attrs.getNamedItem("class");
                if (attr != null) {
                    if (text.length() > 0) {
                        text = String.valueOf(text) + ' ';
                    }
                    text = String.valueOf(text) + '[' + attr.getNodeValue() + ']';
                }
                if (!hasParent && (attr = attrs.getNamedItem("parent")) != null) {
                    if (text.length() > 0) {
                        text = String.valueOf(text) + ' ';
                    }
                    text = String.valueOf(text) + '<' + attr.getNodeValue() + '>';
                }
            }
        } else if (tag == BeansTags.Tag.CONSTRUCTOR_ARG) {
            Node attr = attrs.getNamedItem("index");
            if (attr != null) {
                text = String.valueOf(text) + " {" + attr.getNodeValue() + "}";
            }
            if ((attr = attrs.getNamedItem("type")) != null) {
                text = String.valueOf(text) + " [" + attr.getNodeValue() + "]";
            }
            if ((attr = attrs.getNamedItem("ref")) != null) {
                text = String.valueOf(text) + " <" + attr.getNodeValue() + ">";
            }
            if ((attr = attrs.getNamedItem("value")) != null) {
                text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
            }
        } else if (tag == BeansTags.Tag.PROPERTY) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                text = attr.getNodeValue();
            }
            if (BeansContentOutlineConfiguration.isShowAttributes()) {
                attr = attrs.getNamedItem("ref");
                if (attr != null) {
                    text = String.valueOf(text) + " <" + attr.getNodeValue() + ">";
                }
                if ((attr = attrs.getNamedItem("value")) != null) {
                    text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
                }
            }
        } else if (tag == BeansTags.Tag.LOOKUP_METHOD) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                text = attr.getNodeValue();
            }
            if (BeansContentOutlineConfiguration.isShowAttributes() && (attr = attrs.getNamedItem("bean")) != null) {
                text = String.valueOf(text) + " <" + attr.getNodeValue() + ">";
            }
        } else if (tag == BeansTags.Tag.REPLACE_METHOD) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                text = attr.getNodeValue();
            }
            if (BeansContentOutlineConfiguration.isShowAttributes() && (attr = attrs.getNamedItem("replacer")) != null) {
                text = String.valueOf(text) + " <" + attr.getNodeValue() + ">";
            }
        } else if (tag == BeansTags.Tag.REF || tag == BeansTags.Tag.IDREF) {
            Node attr = attrs.getNamedItem("bean");
            if (attr != null) {
                text = String.valueOf(text) + "<" + attr.getNodeValue() + ">";
            }
            if ((attr = attrs.getNamedItem("local")) != null) {
                text = String.valueOf(text) + "<" + attr.getNodeValue() + ">";
            }
            if ((attr = attrs.getNamedItem("parent")) != null) {
                text = String.valueOf(text) + "<" + attr.getNodeValue() + ">";
            }
        } else if (tag == BeansTags.Tag.VALUE) {
            Node attr;
            text = node.getLocalName();
            if (BeansContentOutlineConfiguration.isShowAttributes() && (attr = attrs.getNamedItem("type")) != null) {
                text = String.valueOf(text) + " [" + attr.getNodeValue() + "]";
            }
        } else if (tag == BeansTags.Tag.ENTRY) {
            text = node.getLocalName();
            Node attr = attrs.getNamedItem("key");
            if (attr != null) {
                text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
            } else {
                attr = attrs.getNamedItem("key-ref");
                if (attr != null) {
                    text = String.valueOf(text) + " <" + attr.getNodeValue() + ">";
                }
            }
            if (BeansContentOutlineConfiguration.isShowAttributes() && (attr = attrs.getNamedItem("value")) != null) {
                text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
            }
        } else if (tag == BeansTags.Tag.PROP) {
            text = node.getLocalName();
            Node attr = node.getFirstChild();
            if (attr != null && attr.getNodeType() == 3) {
                text = String.valueOf(text) + " \"" + attr.getNodeValue() + "\"";
            }
        } else if (tag == BeansTags.Tag.COMMENT) {
            text = super.getText(o);
            text = String.valueOf(text) + " <";
            text = String.valueOf(text) + ((CommentImpl)o).getNodeValue().trim();
            text = String.valueOf(text) + '>';
        } else if (tag != BeansTags.Tag.UNKNOWN) {
            text = node.getLocalName();
        }
        return text;
    }
}

