/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.wizard.WizardImages;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardMainPage;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardMessages;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardModel;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.ProjectWizardDescriptor;
import org.springframework.ide.eclipse.wizard.template.SpringProjectWizardSection;
import org.springframework.ide.eclipse.wizard.template.SpringWizardSectionFactory;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;

public class NewSpringProjectWizard
extends NewElementWizard
implements INewWizard {
    private final NewSpringProjectWizardMainPage mainPage;
    private final SpringWizardSectionFactory sectionFactory;
    private final NewSpringProjectWizardModel model = new NewSpringProjectWizardModel();
    private IProject project;

    public NewSpringProjectWizard() {
        this.setWindowTitle("New Spring Legacy Project");
        this.setDefaultPageImageDescriptor(WizardImages.TEMPLATE_WIZARD_ICON);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.sectionFactory = new SpringWizardSectionFactory(this);
        this.mainPage = new NewSpringProjectWizardMainPage(this.model);
        this.mainPage.setTitle(NewSpringProjectWizardMessages.NewProject_title);
        this.mainPage.setDescription("Create a Spring project by selecting a template or simple project type.");
    }

    public NewSpringProjectWizardMainPage getMainPage() {
        return this.mainPage;
    }

    public NewSpringProjectWizardModel getModel() {
        return this.model;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        List<SpringProjectWizardSection> sections = this.sectionFactory.loadSections();
        for (SpringProjectWizardSection section : sections) {
            List<IWizardPage> pages = section.loadPages();
            if (pages == null) continue;
            for (IWizardPage page : pages) {
                this.addPage(page);
            }
        }
    }

    public boolean hasPages(IWizardPage page) {
        SpringProjectWizardSection section = this.getSection();
        if (section != null) {
            return section.hasNextPage(page);
        }
        return false;
    }

    public boolean canFinish() {
        boolean canFinish = this.mainPage.isPageComplete();
        if (canFinish) {
            SpringProjectWizardSection section = this.getSection();
            canFinish = section != null ? section.canFinish() : false;
        }
        return canFinish;
    }

    protected SpringProjectWizardSection getSection() {
        Template template = (Template)this.getModel().selectedTemplate.getValue();
        if (template != null) {
            ProjectWizardDescriptor descriptor = new ProjectWizardDescriptor(template);
            return this.sectionFactory.getSection(descriptor);
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        SpringProjectWizardSection section = this.getSection();
        if (section != null) {
            return section.getNextPage(page);
        }
        return null;
    }

    public boolean performFinish() {
        SpringProjectWizardSection section;
        boolean finish = super.performFinish();
        if (finish && (section = this.getSection()) != null) {
            CoreException coreException = null;
            try {
                ProjectConfiguration configuration = section.getProjectConfiguration();
                IProject project = this.createProject(configuration);
                this.configureProject(project, configuration);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException error) {
                Throwable t = error.getTargetException();
                if (t instanceof CoreException) {
                    coreException = (CoreException)t;
                } else {
                    BeansUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui", 0, t.toString(), t));
                    MessageDialog.openError((Shell)this.getShell(), (String)NewSpringProjectWizardMessages.NewProject_errorMessage, (String)NLS.bind((String)NewSpringProjectWizardMessages.NewProject_internalError, (Object)t.getMessage()));
                }
            }
            catch (CoreException ce) {
                coreException = ce;
            }
            if (coreException != null) {
                this.handleError(coreException);
            }
        }
        return finish;
    }

    protected IProject createProject(final ProjectConfiguration projectConfiguration) throws InterruptedException, InvocationTargetException, CoreException {
        this.enableWorkspaceBuild(false);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                NewSpringProjectWizard.this.project = projectConfiguration.createProject(monitor);
            }
        };
        this.getContainer().run(false, true, (IRunnableWithProgress)op);
        return this.project;
    }

    protected void configureProject(final IProject project, final ProjectConfiguration projectConfiguration) throws InterruptedException, InvocationTargetException, CoreException {
        this.enableWorkspaceBuild(true);
        final IWorkingSet[] workingSets = this.getWorkingSets();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                projectConfiguration.configureProject(monitor);
                NewSpringProjectWizard.this.selectAndReveal(project);
                if (workingSets != null && workingSets.length > 0) {
                    PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
                }
            }
        };
        this.getContainer().run(false, false, (IRunnableWithProgress)op);
    }

    protected void enableWorkspaceBuild(boolean enable) throws CoreException {
        IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
        if (!wsd.isAutoBuilding() == enable) {
            wsd.setAutoBuilding(enable);
            ResourcesPlugin.getWorkspace().setDescription(wsd);
        }
    }

    protected void handleError(CoreException coreException) {
        if (coreException != null) {
            if (coreException.getStatus().getCode() == 275) {
                String projectName = this.project != null ? this.project.getName() : "";
                MessageDialog.openError((Shell)this.getShell(), (String)NewSpringProjectWizardMessages.NewProject_errorMessage, (String)NLS.bind((String)NewSpringProjectWizardMessages.NewProject_caseVariantExistsError, (Object)projectName));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewSpringProjectWizardMessages.NewProject_errorMessage, null, (IStatus)coreException.getStatus());
            }
        }
    }

    public IWorkingSet[] getWorkingSets() {
        return this.mainPage.getSelectedWorkingSets();
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    public void selectAndReveal(IProject project) {
        super.selectAndReveal((IResource)project);
    }

    public IJavaElement getCreatedElement() {
        return null;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
    }

    public boolean performCancel() {
        SpringProjectWizardSection section = this.getSection();
        if (section != null) {
            section.cancel();
        }
        return true;
    }
}

