/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateElement;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.TemplateCategory;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;

public class TemplateContentProvider
implements ITreeContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return element instanceof TemplateCategory && ((TemplateCategory)element).getChildren().size() > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<ITemplateElement> elements = new ArrayList<ITemplateElement>();
        if (inputElement instanceof List) {
            List templates = (List)inputElement;
            HashMap<String, TemplateCategory> pathToCategory = new HashMap<String, TemplateCategory>();
            for (Object obj : templates) {
                String categoryPath;
                if (!(obj instanceof Template)) continue;
                Template template = (Template)obj;
                Descriptor descriptor = template.getItem().getLocalDescriptor();
                if (descriptor == null) {
                    descriptor = template.getItem().getRemoteDescriptor();
                }
                if ((categoryPath = descriptor.getCategory()) == null) {
                    elements.add(template);
                    continue;
                }
                String[] categoryPaths = categoryPath.split("/");
                TemplateCategory lastCategory = null;
                String path = "";
                String[] stringArray = categoryPaths;
                int n = categoryPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean topLevel;
                    String categoryName = stringArray[n2];
                    if (path.length() == 0) {
                        path = categoryName;
                        topLevel = true;
                    } else {
                        path = String.valueOf(path) + "/" + categoryName;
                        topLevel = false;
                    }
                    TemplateCategory category = (TemplateCategory)pathToCategory.get(path);
                    if (category == null) {
                        category = new TemplateCategory(categoryName);
                        pathToCategory.put(path, category);
                        if (topLevel) {
                            elements.add(category);
                        } else if (lastCategory != null) {
                            lastCategory.addChild(category);
                        }
                    }
                    lastCategory = category;
                    ++n2;
                }
                if (lastCategory == null) continue;
                lastCategory.addChild(template);
            }
        }
        return elements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TemplateCategory) {
            return ((TemplateCategory)parentElement).getChildren().toArray();
        }
        return null;
    }
}

