/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.wizard.template.util.AbstractNameUrlPreferenceModel;
import org.springframework.ide.eclipse.wizard.template.util.AddEditNameUrlDialogMessages;
import org.springframework.ide.eclipse.wizard.template.util.NameUrlPair;

public class AddEditNameUrlDialog
extends Dialog {
    AbstractNameUrlPreferenceModel model;
    Text nameText;
    Text urlText;
    String name;
    String urlString;
    private final String explanatoryText;
    protected Label errorTextLabel;
    protected Composite composite;
    private String title;

    public AddEditNameUrlDialog(Shell parent, AbstractNameUrlPreferenceModel aModel, NameUrlPair nameUrl, String headerText) {
        super(parent);
        this.explanatoryText = headerText;
        this.model = aModel;
        if (nameUrl != null) {
            this.name = nameUrl.getName();
            this.urlString = nameUrl.getUrlString();
        } else {
            this.name = null;
            this.urlString = null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 13, 10, 0).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        Label explanatoryTextLabel = new Label(this.composite, 64);
        explanatoryTextLabel.setText(this.explanatoryText);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)explanatoryTextLabel);
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText(NLS.bind((String)"Name:", null));
        nameLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.nameText = new Text(this.composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.nameText);
        this.nameText.setEditable(true);
        if (this.name != null && this.name.length() > 0) {
            this.nameText.setText(this.name);
        }
        Label urlLabel = new Label(this.composite, 0);
        urlLabel.setText(NLS.bind((String)"URL:", null));
        urlLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.urlText = new Text(this.composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.urlText);
        this.urlText.setEditable(true);
        if (this.urlString != null && this.urlString.length() > 0) {
            this.urlText.setText(this.urlString);
        }
        this.urlText.addKeyListener(this.getUrlValidationListener());
        String errorText = "";
        this.errorTextLabel = new Label(this.composite, 64);
        this.errorTextLabel.setText(errorText);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.errorTextLabel);
        return this.composite;
    }

    public void create() {
        super.create();
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        this.getButton(0).setEnabled(this.validateUrl(this.urlString));
    }

    protected KeyListener getUrlValidationListener() {
        return new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String urlString = ((Text)e.getSource()).getText().trim();
                if (!AddEditNameUrlDialog.this.validateUrl(urlString)) {
                    AddEditNameUrlDialog.this.getButton(0).setEnabled(false);
                } else {
                    AddEditNameUrlDialog.this.errorTextLabel.setText("");
                    AddEditNameUrlDialog.this.composite.update();
                    AddEditNameUrlDialog.this.getButton(0).setEnabled(true);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        };
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.urlString = this.urlText.getText();
        if (this.urlString.length() > 0 && this.name.length() <= 0) {
            this.name = this.urlString;
        }
        super.okPressed();
    }

    public String getUrlString() {
        return this.urlString;
    }

    public String getName() {
        return this.name;
    }

    protected boolean validateUrl(String urlString) {
        if (urlString != null && urlString.contains(" ")) {
            urlString = urlString.replace(" ", "%20");
            int caret = this.urlText.getCaretPosition();
            this.urlText.setText(urlString);
            this.urlText.setSelection(caret + "%20".length() - 1);
        }
        if (urlString == null || urlString.length() <= 0) {
            return false;
        }
        try {
            new URI(urlString);
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.showError();
        }
        try {
            URL url = new URL(urlString);
            if (url.getHost().isEmpty()) {
                return this.showError();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return this.showError();
        }
        return true;
    }

    private boolean showError() {
        this.errorTextLabel.setText(AddEditNameUrlDialogMessages.malformedUrl);
        this.composite.update();
        return false;
    }

    protected void setTitle(String title) {
        this.title = title;
    }
}

