/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springsource.ide.eclipse.commons.core.FileUtil;
import org.springsource.ide.eclipse.commons.core.ZipFileUtil;

public class ExampleProjectsImporterJob
extends WorkspaceJob
implements IOverwriteQuery {
    private final String projectName;
    private final URI uri;
    private final Shell shell;
    public static final String URL_SUFFIX = "/zipball/master";

    public ExampleProjectsImporterJob(URI myUri, String myProjectName, Shell myShell) {
        super("Importing " + myProjectName);
        this.uri = myUri;
        this.projectName = myProjectName;
        this.shell = myShell;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        URL url;
        File archiveFile = this.getArchiveFile(this.projectName);
        File targetDirectory = new File(this.projectName);
        try {
            url = this.uri.toURL();
            if (url.getProtocol().startsWith("http")) {
                if (url.getHost().endsWith("github.com")) {
                    if (!url.getPath().endsWith(URL_SUFFIX)) {
                        String urlString = String.valueOf(url.getProtocol()) + "://" + url.getAuthority();
                        if (url.getPort() != -1) {
                            urlString = String.valueOf(urlString) + ":" + url.getPort();
                        }
                        urlString = String.valueOf(urlString) + url.getPath() + URL_SUFFIX;
                        url = new URL(urlString);
                    }
                } else {
                    System.err.println("Uh-oh, this is not a github URL");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"The URL {0} is malformed", (Object)this.uri));
        }
        try {
            ZipFileUtil.unzip((URL)url, (File)targetDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        catch (IOException iOException) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error downloading {0} to {1}", (Object)url, (Object)archiveFile.getAbsolutePath()));
        }
        catch (OperationCanceledException operationCanceledException) {
            System.err.println("Operation cancelled!");
            monitor.done();
            return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Cancelled download of {0} to {1}.", (Object)url, (Object)archiveFile.getAbsolutePath()));
        }
        if (!targetDirectory.exists()) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Download of {0} failed", (Object)archiveFile.getAbsolutePath()));
        }
        File[] subdirs = targetDirectory.listFiles();
        if (subdirs.length <= 0) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"The zip file downloaded from {0} was empty", (Object)url));
        }
        File projectFile = null;
        File pomFile = null;
        File[] fileArray = subdirs;
        if (subdirs.length != 0) {
            File subdir = fileArray[0];
            if (subdir.isDirectory()) {
                IStatus creationStatus;
                File[] projectFiles;
                boolean hasClasspath = false;
                File[] fileArray2 = projectFiles = subdir.listFiles();
                int n = projectFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File aFile = fileArray2[n2];
                    if (aFile.getName().equals(".project")) {
                        projectFile = aFile;
                    }
                    if (aFile.getName().equals(".classpath")) {
                        hasClasspath = true;
                    }
                    if (aFile.getName().equals("pom.xml")) {
                        pomFile = aFile;
                    }
                    ++n2;
                }
                if (hasClasspath && projectFile != null) {
                    creationStatus = this.createExistingEclipseProject(projectFile, monitor);
                    this.deleteRecursive(targetDirectory);
                } else if (pomFile != null) {
                    creationStatus = this.createExistingMavenProject(pomFile, monitor);
                    if (!ExampleProjectsImporterJob.hasMaven()) {
                        String message = NLS.bind((String)"You do not appear to have Maven installed.  This project requires Maven to import and build.", null);
                        creationStatus = new Status(4, "org.springframework.ide.eclipse.wizard", message);
                    }
                } else {
                    creationStatus = new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Project {0} does not have either pom.xml or .project/.classpath", (Object)this.projectName));
                }
                monitor.done();
                return creationStatus;
            }
            monitor.done();
            return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Download of {0} successful", (Object)this.projectName));
        }
        monitor.done();
        return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Unforeseen error downloading {0} from {1}", (Object)this.projectName, (Object)url));
    }

    private IStatus createExistingEclipseProject(File projectFile, IProgressMonitor monitor) {
        IProjectDescription downloadedDescription;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.setTaskName("Loading Eclipse project");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectName);
        URI locationURI = projectFile.toURI();
        try {
            downloadedDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)new Path(projectFile.getPath()));
            downloadedDescription.setLocation(null);
        }
        catch (CoreException coreException) {
            return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Could parse{0}, maybe it is corrupted?", (Object)projectFile.getAbsolutePath()));
        }
        if (locationURI != null) {
            IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
            if (!result.isOK()) {
                return result;
            }
            IProjectDescription newDesc = workspace.newProjectDescription(this.projectName);
            newDesc.setBuildSpec(downloadedDescription.getBuildSpec());
            newDesc.setComment(downloadedDescription.getComment());
            newDesc.setDynamicReferences(downloadedDescription.getDynamicReferences());
            newDesc.setNatureIds(downloadedDescription.getNatureIds());
            newDesc.setReferencedProjects(downloadedDescription.getReferencedProjects());
            try {
                monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                if (project.exists()) {
                    sub.worked(30);
                    return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Project {0} already exists.", (Object)project.getName()));
                }
                project.create(newDesc, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                sub.worked(30);
            }
            catch (CoreException coreException) {
                return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Could not create project from {0}", (Object)projectFile));
            }
            File importSource = new File(locationURI).getParentFile();
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
            ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
            operation.setContext(this.shell);
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException invocationTargetException) {
                return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Could not create project from {0}", (Object)projectFile));
            }
            catch (InterruptedException interruptedException) {
                return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Import of {0} interrupted", (Object)this.projectName));
            }
            sub.worked(70);
            this.deleteRecursive(importSource.getParentFile());
        }
        return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Import of {0} successful", (Object)this.projectName));
    }

    public IStatus createExistingMavenProject(File pomFile, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.setTaskName("Loading Maven project");
        IPath projectPath = Platform.getLocation().append(this.projectName);
        File downloadDirectory = pomFile.getParentFile();
        File projectWorkspaceDirectory = projectPath.toFile();
        if (!projectWorkspaceDirectory.exists() && !projectWorkspaceDirectory.mkdir()) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Could not make directory {0}", (Object)projectWorkspaceDirectory));
        }
        try {
            FileUtil.copyDirectory((File)downloadDirectory.getAbsoluteFile(), (File)projectWorkspaceDirectory.getAbsoluteFile(), (IProgressMonitor)monitor);
        }
        catch (CoreException coreException) {
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Could not copy project files from {0} to {1}", (Object)downloadDirectory.getAbsoluteFile(), (Object)projectWorkspaceDirectory.getAbsoluteFile()));
        }
        sub.worked(50);
        File newPomFile = projectPath.append("pom.xml").toFile();
        if (!newPomFile.exists()) {
            monitor.done();
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Pom file not found at", (Object)newPomFile.getAbsolutePath()));
        }
        Object creationStatus = ExampleProjectsImporterJob.hasMaven() ? ExampleProjectsImporterJob.createEclipseProjectFromExistingMavenProject(newPomFile, monitor) : new Status(2, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Maven is not installed, cannot create a project from {0}", (Object)pomFile));
        sub.worked(50);
        this.deleteRecursive(pomFile.getParentFile().getParentFile());
        return creationStatus;
    }

    public static IStatus createEclipseProjectFromExistingMavenProject(File pomFile, IProgressMonitor monitor) {
        try {
            MavenCorePlugin.createEclipseProjectFromExistingMavenProject((File)pomFile, (IProgressMonitor)monitor);
        }
        catch (CoreException coreException) {
            monitor.done();
            return new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Error: Could not create project from {0}", (Object)pomFile));
        }
        monitor.done();
        return new Status(0, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Import of {0} successful", (Object)pomFile));
    }

    public String queryOverwrite(String pathString) {
        return "YES";
    }

    private File getArchiveFile(String projectName) {
        return new File(String.valueOf(projectName) + ".zip");
    }

    private static boolean hasMaven() {
        return MavenCorePlugin.IS_M2ECLIPSE_PRESENT;
    }

    private void deleteRecursive(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                this.deleteRecursive(subFile);
                ++n2;
            }
        }
        file.delete();
    }
}

