/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.reporting;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.tigris.subversion.subclipse.tools.usage.util.collectionfilter.CollectionFilterUtils;
import org.tigris.subversion.subclipse.tools.usage.util.collectionfilter.ICollectionFilter;

public class SubclipseComponents {
    public static final String[] subclipseFeatureIdentifiers = new String[]{"org.tigris.subversion.clientadapter.feature", "org.tigris.subversion.clientadapter.javahl.feature", "org.tigris.subversion.clientadapter.svnkit.feature", "org.tigris.subversion.subclipse", "org.tigris.subversion.subclipse.graph.feature", "com.collabnet.subversion.merge.feature"};
    public static final String[] subclipseFeatureNames = new String[]{"CLIENTADAPTER", "JAVAHL", "SVNKIT", "SUBCLIPSE", "GRAPH", "MERGE"};
    private static String subclipseVersion;

    private SubclipseComponents() {
    }

    public static Collection getComponentIds(IBundleGroupProvider[] bundleGroupProviders) {
        TreeSet componentNames = new TreeSet();
        int i = 0;
        while (i < bundleGroupProviders.length) {
            CollectionFilterUtils.filter(new SubclipseFeaturesFilter(componentNames), bundleGroupProviders[i].getBundleGroups(), null);
            ++i;
        }
        return componentNames;
    }

    public static String getSubclipseVersion() {
        return subclipseVersion;
    }

    private static class SubclipseFeaturesFilter
    implements ICollectionFilter {
        private Collection componentNames;

        private SubclipseFeaturesFilter(Collection componentNames) {
            this.componentNames = componentNames;
        }

        public boolean matches(Object object) {
            if (object instanceof IBundleGroup) {
                IBundleGroup bundleGroup = (IBundleGroup)object;
                int i = 0;
                while (i < subclipseFeatureIdentifiers.length) {
                    if (subclipseFeatureIdentifiers[i].equals(bundleGroup.getIdentifier())) {
                        if (subclipseFeatureNames[i].equalsIgnoreCase("SUBCLIPSE")) {
                            subclipseVersion = bundleGroup.getVersion();
                        }
                        this.componentNames.add(subclipseFeatureNames[i]);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

