/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationmetadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataHint;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.boot.configurationmetadata.JsonReader;
import org.springframework.boot.configurationmetadata.RawConfigurationMetadata;
import org.springframework.boot.configurationmetadata.SimpleConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.ide.eclipse.org.json.JSONException;

public final class ConfigurationMetadataRepositoryJsonBuilder {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private Charset defaultCharset = UTF_8;
    private final JsonReader reader = new JsonReader();
    private final List<RawConfigurationMetadata> rawDatas = new ArrayList<RawConfigurationMetadata>();

    private ConfigurationMetadataRepositoryJsonBuilder(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public ConfigurationMetadataRepositoryJsonBuilder withJsonResource(Object origin, InputStream inputStream) throws IOException {
        return this.withJsonResource(origin, inputStream, this.defaultCharset);
    }

    public ConfigurationMetadataRepositoryJsonBuilder withJsonResource(Object origin, InputStream inputStream, Charset charset) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must not be null.");
        }
        this.rawDatas.add(this.parseRaw(origin, inputStream, charset));
        return this;
    }

    public ConfigurationMetadataRepository build() {
        SimpleConfigurationMetadataRepository result = new SimpleConfigurationMetadataRepository();
        result.include(this.create(this.rawDatas));
        return result;
    }

    private RawConfigurationMetadata parseRaw(Object origin, InputStream in, Charset charset) throws IOException {
        try {
            return this.reader.read(origin, in, charset);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to read configuration metadata", ex);
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("Invalid configuration metadata document", ex);
        }
    }

    private SimpleConfigurationMetadataRepository create(Iterable<RawConfigurationMetadata> metadatas) {
        SimpleConfigurationMetadataRepository repository = new SimpleConfigurationMetadataRepository();
        for (RawConfigurationMetadata metadata : metadatas) {
            repository.add(metadata.getSources());
        }
        for (RawConfigurationMetadata metadata : metadatas) {
            for (ConfigurationMetadataItem item : metadata.getItems()) {
                ConfigurationMetadataSource source = this.getSource(metadata, item);
                repository.add(item, source);
            }
        }
        for (RawConfigurationMetadata metadata : metadatas) {
            Map<String, ConfigurationMetadataProperty> allProperties = repository.getAllProperties();
            for (ConfigurationMetadataHint hint : metadata.getHints()) {
                ConfigurationMetadataProperty property = allProperties.get(hint.getId());
                if (property != null) {
                    this.addValueHints(property, hint);
                    continue;
                }
                String id = hint.resolveId();
                property = allProperties.get(id);
                if (property == null) continue;
                if (hint.isMapKeyHints()) {
                    this.addMapHints(property, hint);
                    continue;
                }
                this.addValueHints(property, hint);
            }
        }
        return repository;
    }

    private void addValueHints(ConfigurationMetadataProperty property, ConfigurationMetadataHint hint) {
        this.addAll(property.getHints().getValueHints(), hint.getValueHints());
        property.getHints().getValueProviders().addAll(hint.getValueProviders());
    }

    private void addMapHints(ConfigurationMetadataProperty property, ConfigurationMetadataHint hint) {
        this.addAll(property.getHints().getKeyHints(), hint.getValueHints());
        property.getHints().getKeyProviders().addAll(hint.getValueProviders());
    }

    private void addAll(List<ValueHint> existing, List<ValueHint> toAdd) {
        if (existing.isEmpty()) {
            existing.addAll(toAdd);
        } else if (!toAdd.isEmpty()) {
            Set existingValues = existing.stream().map(hint -> "" + hint.getValue()).collect(Collectors.toSet());
            for (ValueHint hint2 : toAdd) {
                if (existingValues.contains("" + hint2.getValue())) continue;
                existing.add(hint2);
            }
        }
    }

    private ConfigurationMetadataSource getSource(RawConfigurationMetadata metadata, ConfigurationMetadataItem item) {
        if (item.getSourceType() != null) {
            return metadata.getSource(item.getSourceType());
        }
        return null;
    }

    public static ConfigurationMetadataRepositoryJsonBuilder create(InputStream ... inputStreams) throws IOException {
        ConfigurationMetadataRepositoryJsonBuilder builder = ConfigurationMetadataRepositoryJsonBuilder.create();
        InputStream[] inputStreamArray = inputStreams;
        int n = inputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream inputStream = inputStreamArray[n2];
            builder = builder.withJsonResource(null, inputStream);
            ++n2;
        }
        return builder;
    }

    public static ConfigurationMetadataRepositoryJsonBuilder create() {
        return ConfigurationMetadataRepositoryJsonBuilder.create(UTF_8);
    }

    public static ConfigurationMetadataRepositoryJsonBuilder create(Charset defaultCharset) {
        return new ConfigurationMetadataRepositoryJsonBuilder(defaultCharset);
    }
}

