/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationmetadata;

import java.text.BreakIterator;
import java.util.Locale;

class DescriptionExtractor {
    private static final String NEW_LINE = System.getProperty("line.separator");

    DescriptionExtractor() {
    }

    public String getShortDescription(String description) {
        if (description == null) {
            return null;
        }
        int dot = description.indexOf(".");
        if (dot != -1) {
            BreakIterator breakIterator = BreakIterator.getSentenceInstance(Locale.US);
            breakIterator.setText(description);
            String text = description.substring(breakIterator.first(), breakIterator.next()).trim();
            return this.removeSpaceBetweenLine(text);
        }
        String[] lines = description.split(NEW_LINE);
        return lines[0].trim();
    }

    private String removeSpaceBetweenLine(String text) {
        String[] lines = text.split(NEW_LINE);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            sb.append(line.trim()).append(" ");
            ++n2;
        }
        return sb.toString().trim();
    }
}

