/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.PreferencesBasedSeverityProvider;
import org.springframework.ide.eclipse.editor.support.reconcile.SeverityProvider;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;

public class DocumentContextFinders {
    public static final DocumentContextFinder YAML_DEFAULT = DocumentContextFinders.defaultFor(EditorType.YAML);
    public static final DocumentContextFinder PROPS_DEFAULT = DocumentContextFinders.defaultFor(EditorType.PROP);

    private static final DocumentContextFinder defaultFor(final EditorType editorType) {
        return new DocumentContextFinder(){

            @Override
            public IJavaProject getJavaProject(IDocument doc) {
                return DocumentUtil.getJavaProject((IDocument)doc);
            }

            @Override
            public SeverityProvider getSeverityProvider(IDocument doc) {
                IProject p = DocumentUtil.getProject((IDocument)doc);
                ScopedPreferenceStore projectPrefs = null;
                if (p != null) {
                    projectPrefs = new ScopedPreferenceStore((IScopeContext)new ProjectScope(p), "org.springframework.ide.eclipse.boot.properties.editor");
                }
                return new PreferencesBasedSeverityProvider((IPreferenceStore)projectPrefs, (IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.springframework.ide.eclipse.boot.properties.editor"), editorType);
            }
        };
    }
}

