/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Provider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinders;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.completions.LazyProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.completions.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ValueHintHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProviders;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.PropertyNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.completions.DocumentEdits;
import org.springframework.ide.eclipse.editor.support.completions.ICompletionEngine;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import org.springframework.ide.eclipse.editor.support.util.PrefixFinder;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class SpringPropertiesCompletionEngine
implements HoverInfoProvider,
ICompletionEngine {
    private boolean preferLowerCaseEnums = true;
    public static final Pattern ASSIGN = Pattern.compile("^(\\h)*(=|:)(\\h|\\\\\\s)*");
    private static final boolean DEBUG = false;
    public static final boolean DEFAULT_VALUE_INCLUDED = false;
    private static final PrefixFinder valuePrefixFinder = new PrefixFinder(){

        protected boolean isPrefixChar(char c) {
            return SpringPropertiesCompletionEngine.isValuePrefixChar(c);
        }
    };
    private static final PrefixFinder fuzzySearchPrefix = new PrefixFinder(){

        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c);
        }
    };
    private static final PrefixFinder navigationPrefixFinder = new PrefixFinder(){

        public String getPrefix(IDocument doc, int offset) {
            String prefix = super.getPrefix(doc, offset);
            char charBefore = this.getCharBefore(doc, prefix, offset);
            if (charBefore == '.' || charBefore == ']') {
                return prefix;
            }
            return null;
        }

        private char getCharBefore(IDocument doc, String prefix, int offset) {
            try {
                int offsetBefore;
                if (prefix != null && (offsetBefore = offset - prefix.length() - 1) >= 0) {
                    return doc.getChar(offsetBefore);
                }
            }
            catch (BadLocationException badLocationException) {}
            return '\u0000';
        }

        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c) && c != ']' && c != ']' && c != '.';
        }
    };
    private static final IContentProposal[] NO_CONTENT_PROPOSALS = new IContentProposal[0];
    private DocumentContextFinder documentContextFinder = null;
    private Provider<FuzzyMap<PropertyInfo>> indexProvider = null;
    private TypeUtil typeUtil = null;
    private PropertyCompletionFactory completionFactory = null;

    public static void debug(String msg) {
    }

    private static boolean isValuePrefixChar(char c) {
        return !Character.isWhitespace(c) && c != ',';
    }

    public SpringPropertiesCompletionEngine() {
    }

    public SpringPropertiesCompletionEngine(final IJavaProject jp) throws Exception {
        this.indexProvider = new Provider<FuzzyMap<PropertyInfo>>(){

            public FuzzyMap<PropertyInfo> get() {
                return SpringPropertiesEditorPlugin.getIndexManager().get(jp);
            }
        };
        this.setDocumentContextFinder(DocumentContextFinders.PROPS_DEFAULT);
        this.typeUtil = new TypeUtil(jp);
    }

    public Collection<ICompletionProposal> getCompletions(IDocument doc, int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(doc, offset);
        String type = partition.getType();
        if (type.equals("__dftl_partition_content_type")) {
            return this.getPropertyCompletions(doc, offset);
        }
        if (type.equals("__pf_roperty_value")) {
            return this.getValueCompletions(doc, offset, (IRegion)partition);
        }
        return Collections.emptyList();
    }

    private Collection<ICompletionProposal> getNavigationProposals(IDocument doc, int offset) {
        String navPrefix = navigationPrefixFinder.getPrefix(doc, offset);
        try {
            PropertyInfo prop;
            int navOffset;
            if (navPrefix != null && (navPrefix = fuzzySearchPrefix.getPrefix(doc, navOffset = offset - navPrefix.length() - 1)) != null && !navPrefix.isEmpty() && (prop = SpringPropertiesCompletionEngine.findLongestValidProperty(this.getIndex(), navPrefix)) != null) {
                int regionStart = navOffset - navPrefix.length();
                Collection<ICompletionProposal> hintProposals = this.getKeyHintProposals(doc, prop, navOffset, offset);
                if (CollectionUtil.hasElements(hintProposals)) {
                    return hintProposals;
                }
                PropertyNavigator navigator = new PropertyNavigator(doc, null, this.typeUtil, this.region(regionStart, navOffset));
                Type type = navigator.navigate(regionStart + prop.getId().length(), TypeParser.parse(prop.getType()));
                if (type != null) {
                    return this.getNavigationProposals(doc, type, navOffset, offset);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    private Collection<ICompletionProposal> getKeyHintProposals(IDocument doc, PropertyInfo prop, int navOffset, int offset) {
        String query;
        List<TypedProperty> hintProperties;
        HintProvider hintProvider = prop.getHints(this.typeUtil, false);
        if (!HintProviders.isNull(hintProvider) && CollectionUtil.hasElements(hintProperties = hintProvider.getPropertyHints(query = this.textBetween(doc, navOffset + 1, offset)))) {
            return this.createPropertyProposals(doc, TypeParser.parse(prop.getType()), navOffset, offset, query, hintProperties);
        }
        return ImmutableList.of();
    }

    private String textBetween(IDocument doc, int start, int end) {
        if (end > doc.getLength()) {
            end = doc.getLength();
        }
        if (start > doc.getLength()) {
            start = doc.getLength();
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start < end) {
            try {
                return doc.get(start, end - start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private IRegion region(int start, int end) {
        return new Region(start, end - start);
    }

    private Collection<ICompletionProposal> getNavigationProposals(IDocument doc, Type type, int navOffset, int offset) {
        try {
            String prefix;
            TypeUtil.EnumCaseMode caseMode;
            List<TypedProperty> objectProperties;
            char navOp = doc.getChar(navOffset);
            if (navOp == '.' && (objectProperties = this.typeUtil.getProperties(type, caseMode = this.caseMode(prefix = doc.get(navOffset + 1, offset - (navOffset + 1))), TypeUtil.BeanPropertyNameMode.HYPHENATED)) != null && !objectProperties.isEmpty()) {
                return this.createPropertyProposals(doc, type, navOffset, offset, prefix, objectProperties);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    protected Collection<ICompletionProposal> createPropertyProposals(IDocument doc, Type type, int navOffset, int offset, String prefix, List<TypedProperty> objectProperties) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (TypedProperty prop : objectProperties) {
            double score = FuzzyMatcher.matchScore((String)prefix, (String)prop.getName());
            if (score == 0.0) continue;
            Type valueType = prop.getType();
            String postFix = this.propertyCompletionPostfix(valueType);
            DocumentEdits edits = new DocumentEdits(doc);
            edits.delete(navOffset + 1, offset);
            edits.insert(offset, String.valueOf(prop.getName()) + postFix);
            proposals.add((ICompletionProposal)this.completionFactory.beanProperty(doc, null, type, prefix, prop, score, (ProposalApplier)edits, this.typeUtil));
        }
        return proposals;
    }

    protected TypeUtil.EnumCaseMode caseMode(String prefix) {
        TypeUtil.EnumCaseMode caseMode = "".equals(prefix) ? (this.preferLowerCaseEnums ? TypeUtil.EnumCaseMode.LOWER_CASE : TypeUtil.EnumCaseMode.ORIGNAL) : (Character.isLowerCase(prefix.charAt(0)) ? TypeUtil.EnumCaseMode.LOWER_CASE : TypeUtil.EnumCaseMode.ORIGNAL);
        return caseMode;
    }

    protected String propertyCompletionPostfix(Type type) {
        String postfix = "";
        if (type != null) {
            if (this.typeUtil.isAssignableType(type)) {
                postfix = "=";
            } else if (TypeUtil.isBracketable(type)) {
                postfix = "[";
            } else if (this.typeUtil.isDotable(type)) {
                postfix = ".";
            }
        }
        return postfix;
    }

    public static boolean isAssign(char assign) {
        return assign == ':' || assign == '=';
    }

    private ITypedRegion getPartition(IDocument doc, int offset) throws BadLocationException {
        ITypedRegion previousPart;
        int previousEnd;
        ITypedRegion part = TextUtilities.getPartition((IDocument)doc, (String)"___pf_partitioning", (int)offset, (boolean)true);
        if (part.getType() == "__dftl_partition_content_type" && part.getLength() == 0 && offset == doc.getLength() && offset > 0 && !this.newlineBefore(doc, offset) && (previousEnd = (previousPart = TextUtilities.getPartition((IDocument)doc, (String)"___pf_partitioning", (int)(offset - 1), (boolean)false)).getOffset() + previousPart.getLength()) == offset) {
            return previousPart;
        }
        return part;
    }

    private boolean newlineBefore(IDocument doc, int offset) {
        try {
            if (offset > 0) {
                char c = doc.getChar(offset - 1);
                return c == '\n' || c == '\r';
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    private HoverInfo getValueHoverInfo(DocumentRegion value) {
        try {
            StsValueHint hint;
            String valueString = value.toString();
            IDocument doc = value.getDocument();
            ITypedRegion valuePartition = this.getPartition(value.getDocument(), value.getStart());
            int valuePartitionStart = valuePartition.getOffset();
            String propertyName = fuzzySearchPrefix.getPrefix(doc, valuePartitionStart);
            Type type = this.getValueType(propertyName);
            if (TypeUtil.isArray(type) || TypeUtil.isList(type)) {
                type = TypeUtil.getDomainType(type);
            }
            if (TypeUtil.isClass(type) && (hint = StsValueHint.className(valueString, this.typeUtil)) != null) {
                return new ValueHintHoverInfo(hint);
            }
            Collection<StsValueHint> hints = this.getValueHints(valueString, propertyName, TypeUtil.EnumCaseMode.ALIASED);
            if (hints != null) {
                for (StsValueHint h : hints) {
                    if (!valueString.equals(h.getValue())) continue;
                    return new ValueHintHoverInfo(h);
                }
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    private Collection<ICompletionProposal> getValueCompletions(IDocument doc, int offset, IRegion valuePartition) {
        int regionStart = valuePartition.getOffset();
        try {
            Collection<StsValueHint> valueCompletions;
            int startOfValue = this.skipAssign(doc, offset, valuePartition);
            String query = valuePrefixFinder.getPrefix(doc, offset, startOfValue);
            startOfValue = offset - query.length();
            TypeUtil.EnumCaseMode caseMode = this.caseMode(query);
            String propertyName = fuzzySearchPrefix.getPrefix(doc, regionStart);
            if (propertyName != null && (valueCompletions = this.getValueHints(query, propertyName, caseMode)) != null && !valueCompletions.isEmpty()) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (StsValueHint hint : valueCompletions) {
                    String valueCandidate = hint.getValue();
                    double score = FuzzyMatcher.matchScore((String)query, (String)valueCandidate);
                    if (score == 0.0) continue;
                    DocumentEdits edits = new DocumentEdits(doc);
                    edits.delete(startOfValue, offset);
                    edits.insert(offset, valueCandidate);
                    proposals.add((ICompletionProposal)this.completionFactory.valueProposal(valueCandidate, query, this.getValueType(propertyName), score, (ProposalApplier)edits, new ValueHintHoverInfo(hint)));
                }
                return proposals;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return Collections.emptyList();
    }

    private int skipAssign(IDocument doc, int offset, IRegion valuePartition) {
        try {
            String text = doc.get(valuePartition.getOffset(), valuePartition.getLength());
            Matcher matcher = ASSIGN.matcher(text);
            if (matcher.find() && matcher.start() == 0) {
                int len = matcher.end();
                return valuePartition.getOffset() + len;
            }
            return valuePartition.getOffset();
        }
        catch (BadLocationException badLocationException) {
            return valuePartition.getOffset();
        }
    }

    private Collection<StsValueHint> getValueHints(String query, String propertyName, TypeUtil.EnumCaseMode caseMode) {
        HintProvider hintProvider;
        PropertyInfo prop;
        Type type = this.getValueType(propertyName);
        if (TypeUtil.isArray(type) || TypeUtil.isList(type)) {
            type = TypeUtil.getDomainType(type);
        }
        ArrayList<StsValueHint> allHints = new ArrayList<StsValueHint>();
        Collection<StsValueHint> hints = this.typeUtil.getHintValues(type, query, caseMode);
        if (CollectionUtil.hasElements(hints)) {
            allHints.addAll(hints);
        }
        if ((prop = this.getIndex().findLongestCommonPrefixEntry(propertyName)) != null && !HintProviders.isNull(hintProvider = prop.getHints(this.typeUtil, false))) {
            allHints.addAll(hintProvider.getValueHints(query));
        }
        return allHints;
    }

    protected Type getValueType(String propertyName) {
        try {
            PropertyInfo prop = this.getIndex().get(propertyName);
            if (prop != null) {
                return TypeParser.parse(prop.getType());
            }
            prop = SpringPropertiesCompletionEngine.findLongestValidProperty(this.getIndex(), propertyName);
            if (prop != null) {
                Document doc = new Document(propertyName);
                PropertyNavigator navigator = new PropertyNavigator((IDocument)doc, null, this.typeUtil, (IRegion)new Region(0, doc.getLength()));
                return navigator.navigate(prop.getId().length(), TypeParser.parse(prop.getType()));
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    private List<FuzzyMap.Match<PropertyInfo>> findMatches(String prefix) {
        List<FuzzyMap.Match<PropertyInfo>> matches = this.getIndex().find(StringUtil.camelCaseToHyphens((String)prefix));
        return matches;
    }

    private Collection<ICompletionProposal> getPropertyCompletions(IDocument doc, int offset) throws BadLocationException {
        Collection<ICompletionProposal> navProposals = this.getNavigationProposals(doc, offset);
        if (!navProposals.isEmpty()) {
            return navProposals;
        }
        return this.getFuzzyCompletions(doc, offset);
    }

    protected Collection<ICompletionProposal> getFuzzyCompletions(final IDocument doc, final int offset) {
        List<FuzzyMap.Match<PropertyInfo>> matches;
        final String prefix = fuzzySearchPrefix.getPrefix(doc, offset);
        if (prefix != null && (matches = this.findMatches(prefix)) != null && !matches.isEmpty()) {
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(matches.size());
            for (final FuzzyMap.Match match : matches) {
                LazyProposalApplier edits = new LazyProposalApplier(){

                    @Override
                    protected ProposalApplier create() throws Exception {
                        Type type = TypeParser.parse(((PropertyInfo)match.data).getType());
                        DocumentEdits edits = new DocumentEdits(doc);
                        edits.delete(offset - prefix.length(), offset);
                        edits.insert(offset, String.valueOf(((PropertyInfo)match.data).getId()) + SpringPropertiesCompletionEngine.this.propertyCompletionPostfix(type));
                        return edits;
                    }
                };
                proposals.add((ICompletionProposal)this.completionFactory.property(doc, edits, match, this.typeUtil));
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    public IContentProposal[] getPropertyFieldProposals(String contents, int position) {
        List<FuzzyMap.Match<PropertyInfo>> matches;
        String prefix = contents.substring(0, position);
        if (StringUtil.hasText((String)prefix) && (matches = this.findMatches(prefix)) != null && !matches.isEmpty()) {
            IContentProposal[] proposals = new IContentProposal[matches.size()];
            Collections.sort(matches, new Comparator<FuzzyMap.Match<PropertyInfo>>(){

                @Override
                public int compare(FuzzyMap.Match<PropertyInfo> o1, FuzzyMap.Match<PropertyInfo> o2) {
                    int scoreCompare = Double.compare(o2.score, o1.score);
                    if (scoreCompare != 0) {
                        return scoreCompare;
                    }
                    return ((PropertyInfo)o1.data).getId().compareTo(((PropertyInfo)o2.data).getId());
                }
            });
            int i = 0;
            for (FuzzyMap.Match<PropertyInfo> m : matches) {
                proposals[i++] = new ContentProposal(((PropertyInfo)m.data).getId(), ((PropertyInfo)m.data).getDescription());
            }
            return proposals;
        }
        return NO_CONTENT_PROPOSALS;
    }

    public HoverInfo getHoverInfo(IDocument doc, IRegion _region) {
        SpringPropertiesCompletionEngine.debug("getHoverInfo(" + _region + ")");
        ITypedRegion region = this.getHoverRegion(doc, _region.getOffset());
        if (region != null) {
            String contentType = region.getType();
            try {
                if (contentType.equals("__dftl_partition_content_type")) {
                    SpringPropertiesCompletionEngine.debug("hoverRegion = " + region);
                    PropertyInfo best = this.findBestHoverMatch(doc.get(region.getOffset(), region.getLength()).trim());
                    if (best != null) {
                        return new SpringPropertyHoverInfo(this.documentContextFinder.getJavaProject(doc), best);
                    }
                } else if (contentType.equals("__pf_roperty_value")) {
                    return this.getValueHoverInfo(new DocumentRegion(doc, (IRegion)region));
                }
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log(e);
            }
        }
        return null;
    }

    public ITypedRegion getHoverRegion(IDocument document, int offset) {
        try {
            ITypedRegion candidate = this.getPartition(document, offset);
            if (candidate != null) {
                String type = candidate.getType();
                if ("__dftl_partition_content_type".equals(type)) {
                    return candidate;
                }
                if ("__pf_roperty_value".equals(type)) {
                    DocumentRegion valueRegion = new DocumentRegion(document, (IRegion)candidate).trimStart(ASSIGN);
                    return this.getValueHoverRegion(valueRegion, valueRegion.toRelative(offset));
                }
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    private ITypedRegion getValueHoverRegion(DocumentRegion r, int offset) {
        int len = r.length();
        if (offset >= 0 && offset <= len) {
            int start = offset;
            while (start > 0 && SpringPropertiesCompletionEngine.isValuePrefixChar(r.charAt(start - 1))) {
                --start;
            }
            int end = offset;
            while (end < len && SpringPropertiesCompletionEngine.isValuePrefixChar(r.charAt(end))) {
                ++end;
            }
            if (!(r = r.subSequence(start, end)).isEmpty()) {
                return r.asTypedRegion("__pf_roperty_value");
            }
        }
        return null;
    }

    private PropertyInfo findBestHoverMatch(String propName) {
        SpringPropertiesCompletionEngine.debug(">> findBestHoverMatch(" + propName + ")");
        SpringPropertiesCompletionEngine.debug("index size: " + this.getIndex().size());
        PropertyInfo best = null;
        int bestCommonPrefixLen = 0;
        int bestExtraLen = Integer.MAX_VALUE;
        for (PropertyInfo candidate : this.getIndex()) {
            int commonPrefixLen = StringUtil.commonPrefixLength((CharSequence)propName, (CharSequence)candidate.getId());
            int extraLen = candidate.getId().length() - commonPrefixLen;
            if (commonPrefixLen == propName.length() && extraLen == 0) {
                return candidate;
            }
            if (commonPrefixLen <= bestCommonPrefixLen && (commonPrefixLen != bestCommonPrefixLen || extraLen >= bestExtraLen)) continue;
            bestCommonPrefixLen = commonPrefixLen;
            bestExtraLen = extraLen;
            best = candidate;
        }
        SpringPropertiesCompletionEngine.debug("<< findBestHoverMatch(" + propName + "): " + best);
        return best;
    }

    public FuzzyMap<PropertyInfo> getIndex() {
        return (FuzzyMap)this.indexProvider.get();
    }

    public Provider<FuzzyMap<PropertyInfo>> getIndexProvider() {
        return this.indexProvider;
    }

    public void setDocumentContextFinder(DocumentContextFinder it) {
        this.documentContextFinder = it;
        this.completionFactory = new PropertyCompletionFactory(it);
    }

    public void setIndexProvider(Provider<FuzzyMap<PropertyInfo>> it) {
        this.indexProvider = it;
    }

    public void setTypeUtil(TypeUtil it) {
        this.typeUtil = it;
    }

    public TypeUtil getTypeUtil() {
        return this.typeUtil;
    }

    public boolean getPreferLowerCaseEnums() {
        return this.preferLowerCaseEnums;
    }

    public void setPreferLowerCaseEnums(boolean preferLowerCaseEnums) {
        this.preferLowerCaseEnums = preferLowerCaseEnums;
    }

    public static PropertyInfo findLongestValidProperty(FuzzyMap<PropertyInfo> index, String name) {
        int bracketPos = name.indexOf(91);
        int endPos = bracketPos >= 0 ? bracketPos : name.length();
        PropertyInfo prop = null;
        String prefix = null;
        while (endPos > 0 && prop == null) {
            prefix = name.substring(0, endPos);
            String canonicalPrefix = StringUtil.camelCaseToHyphens((String)prefix);
            prop = index.get(canonicalPrefix);
            if (prop != null) continue;
            endPos = name.lastIndexOf(46, endPos - 1);
        }
        if (prop != null) {
            return prop.withId(prefix);
        }
        return null;
    }
}

