/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesFileSourceViewerConfiguration;
import org.springframework.ide.eclipse.boot.properties.editor.util.Listener;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertiesIndexManager;

public class SpringPropertiesFileEditor
extends PropertiesFileEditor
implements Listener<SpringPropertiesIndexManager>,
IPropertyChangeListener {
    public static final IContentType CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.springframework.ide.eclipse.applicationProperties");
    private SpringPropertiesFileSourceViewerConfiguration fSourceViewerConf;

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        this.fSourceViewerConf = new SpringPropertiesFileSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___pf_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fSourceViewerConf);
        SpringPropertiesEditorPlugin.getIndexManager().addListener(this);
        SpringPropertiesEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        SpringPropertiesEditorPlugin.getIndexManager().removeListener(this);
        SpringPropertiesEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void changed(SpringPropertiesIndexManager index) {
        this.fSourceViewerConf.forceReconcile();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("spring.properties.editor.problem.") && this.fSourceViewerConf != null) {
            this.fSourceViewerConf.forceReconcile();
        }
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        String extension;
        IFile file = (IFile)movedElement.getAdapter(IFile.class);
        if (file != null && (extension = file.getFileExtension()) != null) {
            return extension.equals(".properties");
        }
        return false;
    }
}

