/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinders;
import org.springframework.ide.eclipse.boot.properties.editor.IReconcileTrigger;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesHyperlinkDetector;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconcilerFactory;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.SpringPropertyProblemQuickAssistProcessor;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.util.HyperlinkDetectorUtil;
import org.springframework.ide.eclipse.editor.support.ForceableReconciler;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.ICompletionEngine;
import org.springframework.ide.eclipse.editor.support.completions.ProposalProcessor;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoTextHover;
import org.springframework.ide.eclipse.editor.support.hover.HoverInformationControlCreator;
import org.springframework.ide.eclipse.editor.support.reconcile.DefaultQuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemAnnotationHover;
import org.springframework.ide.eclipse.editor.support.util.DefaultUserInteractions;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;

public class SpringPropertiesFileSourceViewerConfiguration
extends PropertiesFileSourceViewerConfiguration
implements IReconcileTrigger {
    private static final String DIALOG_SETTINGS_KEY = PropertiesFileSourceViewerConfiguration.class.getName();
    private static final DocumentContextFinder documentContextFinder = DocumentContextFinders.PROPS_DEFAULT;
    private SpringPropertiesCompletionEngine engine;
    private ForceableReconciler fReconciler;
    private SpringPropertiesReconcilerFactory fReconcilerFactory = new SpringPropertiesReconcilerFactory(){

        @Override
        protected IReconcileEngine createEngine() throws Exception {
            return new SpringPropertiesReconcileEngine(SpringPropertiesFileSourceViewerConfiguration.this.getEngine().getIndexProvider(), SpringPropertiesFileSourceViewerConfiguration.this.getEngine().getTypeUtil());
        }
    };
    private ITextEditor editor;

    public SpringPropertiesFileSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
        this.editor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        try {
            SpringPropertiesCompletionEngine engine = this.getEngine();
            if (engine != null) {
                ContentAssistant a = new ContentAssistant();
                a.setDocumentPartitioning("___pf_partitioning");
                a.setContentAssistProcessor((IContentAssistProcessor)new ProposalProcessor((ICompletionEngine)this.getEngine()), "__dftl_partition_content_type");
                a.setContentAssistProcessor((IContentAssistProcessor)new ProposalProcessor((ICompletionEngine)this.getEngine()), "__pf_roperty_value");
                a.enableColoredLabels(true);
                a.enableAutoActivation(true);
                a.setInformationControlCreator((IInformationControlCreator)new HoverInformationControlCreator(JavaPlugin.getAdditionalInfoAffordanceString()));
                SpringPropertiesFileSourceViewerConfiguration.setSorter(a);
                a.setRestoreCompletionProposalSize(this.getDialogSettings(sourceViewer, DIALOG_SETTINGS_KEY));
                return a;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    private SpringPropertiesCompletionEngine getEngine() throws Exception {
        IJavaProject jp;
        ITextEditor editor;
        if (this.engine == null && (editor = this.getEditor()) != null && (jp = EditorUtility.getJavaProject((IEditorInput)this.getEditor().getEditorInput())) != null) {
            this.engine = new SpringPropertiesCompletionEngine(jp);
        }
        return this.engine;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 0);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ReconcileProblemAnnotationHover delegate = new ReconcileProblemAnnotationHover(sourceViewer, this.getQuickfixContext(sourceViewer));
        try {
            SpringPropertiesCompletionEngine engine;
            if ((contentType.equals("__dftl_partition_content_type") || contentType.equals("__pf_roperty_value")) && (engine = this.getEngine()) != null) {
                return new HoverInfoTextHover(sourceViewer, (HoverInfoProvider)engine, (ITextHover)delegate);
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return delegate;
    }

    protected QuickfixContext getQuickfixContext(ISourceViewer sourceViewer) {
        return new DefaultQuickfixContext("org.springframework.ide.eclipse.boot.properties.editor", this.getPreferencesStore(), sourceViewer, (UserInteractions)new DefaultUserInteractions(this.getShell()));
    }

    protected Shell getShell() {
        return this.editor.getSite().getShell();
    }

    private IDialogSettings getDialogSettings(ISourceViewer sourceViewer, String dialogSettingsKey) {
        IDialogSettings existing = SpringPropertiesEditorPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (existing != null) {
            return existing;
        }
        IDialogSettings created = SpringPropertiesEditorPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        Rectangle windowBounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        int suggestW = (int)((double)windowBounds.width * 0.35);
        int suggestH = (int)((double)suggestW * 0.6);
        if (suggestW > 300) {
            created.put("size.x", suggestW);
            created.put("size.y", suggestH);
        }
        return created;
    }

    public static void setSorter(ContentAssistant a) {
        try {
            Class<?> sorterInterface = Class.forName("org.eclipse.jface.text.contentassist.ICompletionProposalSorter");
            Method m = ContentAssistant.class.getMethod("setSorter", sorterInterface);
            m.invoke((Object)a, CompletionFactory.SORTER);
        }
        catch (Throwable throwable) {}
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fReconciler == null) {
            this.fReconciler = this.fReconcilerFactory.createReconciler(sourceViewer, documentContextFinder, this);
        }
        return this.fReconciler;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        SpringPropertiesHyperlinkDetector myDetector = null;
        try {
            myDetector = new SpringPropertiesHyperlinkDetector(this.getEngine());
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return HyperlinkDetectorUtil.merge(super.getHyperlinkDetectors(sourceViewer), (IHyperlinkDetector)myDetector);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new SpringPropertyProblemQuickAssistProcessor(this.getPreferencesStore(), (UserInteractions)new DefaultUserInteractions(this.getShell())));
        assistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
        return assistant;
    }

    protected IPreferenceStore getPreferencesStore() {
        return SpringPropertiesEditorPlugin.getDefault().getPreferenceStore();
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map superTargets = super.getHyperlinkDetectorTargets(sourceViewer);
        superTargets.remove("org.eclipse.jdt.ui.PropertiesFileEditor");
        return superTargets;
    }

    @Override
    public void forceReconcile() {
        if (this.fReconciler != null) {
            this.fReconciler.forceReconcile();
        }
    }
}

