/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.PartInitException;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;

public class SpringPropertiesHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final IHyperlink[] NO_LINKS = null;
    private HoverInfoProvider engine;

    public SpringPropertiesHyperlinkDetector(HoverInfoProvider engine) {
        this.engine = engine;
    }

    public List<IJavaElement> getSourceElements(IDocument doc, IRegion region) {
        HoverInfo hoverinfo = this.engine.getHoverInfo(doc, region);
        if (hoverinfo != null) {
            return hoverinfo.getJavaElements();
        }
        return Collections.emptyList();
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List<IJavaElement> targets;
        IRegion linkRegion;
        IDocument doc = textViewer.getDocument();
        if (doc != null && (linkRegion = this.engine.getHoverRegion(doc, region.getOffset())) != null && !(targets = this.getSourceElements(doc, linkRegion)).isEmpty()) {
            IHyperlink[] links = new IHyperlink[targets.size()];
            int i = 0;
            while (i < links.length) {
                links[i] = new JavaElementLink(linkRegion, targets.get(i));
                ++i;
            }
            return links;
        }
        return NO_LINKS;
    }

    public class JavaElementLink
    implements IHyperlink {
        private final IRegion region;
        private final IJavaElement element;

        public JavaElementLink(IRegion region, IJavaElement element) {
            this.region = region;
            this.element = element;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public void open() {
            if (this.element != null) {
                try {
                    JavaUI.openInEditor((IJavaElement)this.element);
                }
                catch (PartInitException partInitException) {
                }
                catch (JavaModelException javaModelException) {}
            }
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return JavaElementLabels.getElementLabel((IJavaElement)this.element, (long)JavaElementLabels.ALL_POST_QUALIFIED);
        }
    }
}

