/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.StsConfigMetadataRepositoryJsonLoader;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;

public class SpringPropertyIndex
extends FuzzyMap<PropertyInfo> {
    private ValueProviderRegistry valueProviders;

    public SpringPropertyIndex(ValueProviderRegistry valueProviders, IJavaProject jp) {
        this.valueProviders = valueProviders;
        if (jp != null) {
            try {
                StsConfigMetadataRepositoryJsonLoader loader = new StsConfigMetadataRepositoryJsonLoader();
                ConfigurationMetadataRepository metadata = loader.load(jp);
                Collection<ConfigurationMetadataProperty> allEntries = metadata.getAllProperties().values();
                for (ConfigurationMetadataProperty item : allEntries) {
                    this.add(new PropertyInfo(valueProviders, item));
                }
                for (ConfigurationMetadataGroup group : metadata.getAllGroups().values()) {
                    for (ConfigurationMetadataSource source : group.getSources().values()) {
                        for (ConfigurationMetadataProperty prop : source.getProperties().values()) {
                            PropertyInfo info = (PropertyInfo)this.get(prop.getId());
                            info.addSource(source);
                        }
                    }
                }
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log(e);
            }
        }
    }

    @Override
    public void add(ConfigurationMetadataProperty propertyInfo) {
        this.add(new PropertyInfo(this.valueProviders, propertyInfo));
    }

    public void dumpAsTestData() {
        List allData = this.find("");
        for (FuzzyMap.Match match : allData) {
            PropertyInfo d = (PropertyInfo)match.data;
            System.out.println("data(" + this.dumpString(d.getId()) + ", " + this.dumpString(d.getType()) + ", " + this.dumpString(d.getDefaultValue()) + ", " + this.dumpString(d.getDescription()) + ");");
        }
    }

    private String dumpString(Object v) {
        if (v == null) {
            return "null";
        }
        return this.dumpString("" + v);
    }

    private String dumpString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("\"");
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++n2;
        }
        buf.append("\"");
        return buf.toString();
    }

    @Override
    protected String getKey(PropertyInfo entry) {
        return entry.getId();
    }
}

