/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.util.FileUtil;

public class StsConfigMetadataRepositoryJsonLoader {
    private static final String MAIN_SPRING_CONFIGURATION_METADATA_JSON = "META-INF/spring-configuration-metadata.json";
    public static final String ADDITIONAL_SPRING_CONFIGURATION_METADATA_JSON = "META-INF/additional-spring-configuration-metadata.json";
    public static final String[] JAR_META_DATA_LOCATIONS = new String[]{"META-INF/spring-configuration-metadata.json"};
    public static final String[] PROJECT_META_DATA_LOCATIONS = new String[]{"META-INF/spring-configuration-metadata.json", "META-INF/additional-spring-configuration-metadata.json"};
    private ConfigurationMetadataRepositoryJsonBuilder builder = ConfigurationMetadataRepositoryJsonBuilder.create();

    public ConfigurationMetadataRepository load(IJavaProject project) throws Exception {
        IClasspathEntry[] classpath;
        SpringPropertiesCompletionEngine.debug(">> load ConfigurationMetadataRepository for " + project.getElementName());
        IClasspathEntry[] iClasspathEntryArray = classpath = project.getResolvedClasspath(true);
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry e = iClasspathEntryArray[n2];
            int ekind = e.getEntryKind();
            int ckind = e.getContentKind();
            IPath path = e.getPath();
            if (ekind == 1 && ckind == 2) {
                File jarFile = path.toFile();
                if (FileUtil.isJarFile((File)jarFile)) {
                    this.loadFromJar(jarFile);
                }
            } else if (ekind == 2) {
                this.loadFromProjectDependency(e);
            } else {
                SpringPropertiesCompletionEngine.debug("Skipped: " + this.ekind(ekind) + " " + this.ckind(ckind) + ": " + path);
            }
            ++n2;
        }
        this.loadFromOutputFolder(project);
        ConfigurationMetadataRepository repository = this.builder.build();
        SpringPropertiesCompletionEngine.debug("<< load ConfigurationMetadataRepository for " + project.getElementName() + ": " + repository.getAllProperties().size() + " properties");
        return repository;
    }

    private void loadFromProjectDependency(IClasspathEntry entry) {
        try {
            IProject p;
            String pname = entry.getPath().segment(0);
            if (pname != null && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(pname)).isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                this.loadFromOutputFolder(JavaCore.create((IProject)p));
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
    }

    private void loadFromOutputFolder(IJavaProject project) {
        try {
            IPath outputLoc = project.getOutputLocation();
            if (outputLoc != null) {
                IFolder outputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLoc);
                String[] stringArray = PROJECT_META_DATA_LOCATIONS;
                int n = PROJECT_META_DATA_LOCATIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String mdLoc = stringArray[n2];
                    IFile mdf = outputFolder.getFile((IPath)new Path(mdLoc));
                    this.loadFromJsonFile(mdf);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
    }

    private void loadFromJsonFile(IFile mdf) {
        block15: {
            if (mdf.exists()) {
                InputStream is = null;
                try {
                    try {
                        is = mdf.getContents(true);
                        this.loadFromInputStream(mdf, is);
                    }
                    catch (Exception e) {
                        SpringPropertiesEditorPlugin.log(e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadFromJar(File f) {
        block16: {
            SpringPropertiesCompletionEngine.debug("load from jar: " + f);
            JarFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(f);
                    String[] stringArray = JAR_META_DATA_LOCATIONS;
                    int n = JAR_META_DATA_LOCATIONS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String loc = stringArray[n2];
                        ZipEntry e = jarFile.getEntry(loc);
                        if (e != null) {
                            this.loadFrom(jarFile, e);
                        }
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    SpringPropertiesEditorPlugin.log(e);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadFrom(JarFile jarFile, ZipEntry ze) {
        block14: {
            InputStream is = null;
            try {
                try {
                    is = jarFile.getInputStream(ze);
                    this.loadFromInputStream(String.valueOf(jarFile.getName()) + "[" + ze.getName() + "]", is);
                }
                catch (Throwable e) {
                    SpringPropertiesEditorPlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadFromInputStream(Object origin, InputStream is) throws IOException {
        this.builder.withJsonResource(origin, is);
    }

    private String ckind(int ckind) {
        switch (ckind) {
            case 1: {
                return "SRC";
            }
            case 2: {
                return "BIN";
            }
        }
        return "" + ckind;
    }

    private String ekind(int ekind) {
        switch (ekind) {
            case 3: {
                return "SRC";
            }
            case 1: {
                return "LIB";
            }
            case 2: {
                return "PRJ";
            }
            case 4: {
                return "VAR";
            }
            case 5: {
                return "CON";
            }
        }
        return "" + ekind;
    }
}

