/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import java.util.Collection;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.properties.editor.util.JavaTypeLinks;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public abstract class AbstractPropertyHoverInfo
extends HoverInfo {
    protected final String renderAsHtml() {
        HtmlSnippet description;
        JavaTypeLinks jtLinks = new JavaTypeLinks(this);
        HtmlBuffer html = new HtmlBuffer();
        this.renderId(html);
        String type = this.getType();
        if (type == null) {
            type = Object.class.getName();
        }
        jtLinks.javaTypeLink(html, this.getJavaProject(), type);
        String deflt = AbstractPropertyHoverInfo.formatDefaultValue(this.getDefaultValue());
        if (deflt != null) {
            html.raw("<br><br>");
            html.text("Default: ");
            html.raw("<i>");
            html.text(deflt);
            html.raw("</i>");
        }
        if (this.isDeprecated()) {
            html.raw("<br><br>");
            String reason = this.getDeprecationReason();
            if (StringUtil.hasText((String)reason)) {
                html.bold("Deprecated: ");
                html.text(reason);
            } else {
                html.bold("Deprecated!");
            }
        }
        if ((description = this.getDescription()) != null) {
            html.raw("<br><br>");
            html.snippet(description);
        }
        return html.toString();
    }

    protected final void renderId(HtmlBuffer html) {
        boolean deprecated = this.isDeprecated();
        String tag = deprecated ? "s" : "b";
        String replacement = this.getDeprecationReplacement();
        html.raw("<" + tag + ">");
        html.text(this.getId());
        html.raw("</" + tag + ">");
        if (StringUtil.hasText((String)replacement)) {
            html.text(" -> " + replacement);
        }
        html.raw("<br>");
    }

    protected abstract Object getDefaultValue();

    protected abstract IJavaProject getJavaProject();

    protected abstract HtmlSnippet getDescription();

    protected abstract String getType();

    protected abstract String getDeprecationReason();

    protected abstract String getId();

    protected abstract String getDeprecationReplacement();

    protected abstract boolean isDeprecated();

    public static String formatDefaultValue(Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue instanceof String) {
                return (String)defaultValue;
            }
            if (defaultValue instanceof Number) {
                return ((Number)defaultValue).toString();
            }
            if (defaultValue instanceof Boolean) {
                return Boolean.toString((Boolean)defaultValue);
            }
            if (defaultValue instanceof Object[]) {
                return StringUtil.arrayToCommaDelimitedString((Object[])((Object[])defaultValue));
            }
            if (defaultValue instanceof Collection) {
                return StringUtil.collectionToCommaDelimitedString((Collection)((Collection)defaultValue));
            }
            return defaultValue.toString();
        }
        return null;
    }
}

