/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.completions.AbstractPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;

public class JavaTypeNavigationHoverInfo
extends AbstractPropertyHoverInfo {
    private final String id;
    private final String propName;
    private Type parentType;
    private Type type;
    private TypeUtil typeUtil;
    private Deprecation deprecation;

    public JavaTypeNavigationHoverInfo(String id, String propName, Type fromType, Type toType, TypeUtil typeUtil) {
        TypedProperty prop;
        this.id = id;
        this.propName = propName;
        this.parentType = fromType;
        this.type = toType;
        this.typeUtil = typeUtil;
        Map<String, TypedProperty> props = typeUtil.getPropertiesMap(this.parentType, TypeUtil.EnumCaseMode.ALIASED, TypeUtil.BeanPropertyNameMode.ALIASED);
        if (props != null && (prop = props.get(propName)) != null) {
            this.deprecation = prop.getDeprecation();
        }
    }

    @Override
    protected boolean isDeprecated() {
        return this.deprecation != null;
    }

    @Override
    protected HtmlSnippet getDescription() {
        try {
            List<IJavaElement> jes = this.getAllJavaElements();
            if (jes != null) {
                for (IJavaElement je : jes) {
                    String jdoc;
                    if (!(je instanceof IMember) || (jdoc = JavadocContentAccess2.getHTMLContent((IJavaElement)((IMember)je), (boolean)true)) == null) continue;
                    return HtmlSnippet.raw((String)jdoc);
                }
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public List<IJavaElement> getJavaElements() {
        if (this.propName != null) {
            if (TypeUtil.isMap(this.parentType)) {
                IField f;
                Type enumType = this.typeUtil.getKeyType(this.parentType);
                if (this.typeUtil.isEnum(enumType) && (f = this.typeUtil.getEnumConstant(enumType, this.propName)) != null) {
                    return ImmutableList.of((Object)f);
                }
            } else {
                Type beanType = this.parentType;
                IMethod je = this.typeUtil.getSetter(beanType, this.propName);
                if (je != null) {
                    return Collections.singletonList(je);
                }
                je = this.typeUtil.getGetter(beanType, this.propName);
                if (je != null) {
                    return Collections.singletonList(je);
                }
                je = this.typeUtil.getField(beanType, this.propName);
                if (je != null) {
                    return Collections.singletonList(je);
                }
            }
        }
        return Collections.emptyList();
    }

    private List<IJavaElement> getAllJavaElements() {
        if (this.propName != null) {
            Type beanType = this.parentType;
            if (TypeUtil.isMap(beanType)) {
                IField field;
                Type keyType = this.typeUtil.getKeyType(beanType);
                if (keyType != null && this.typeUtil.isEnum(keyType) && (field = this.typeUtil.getEnumConstant(keyType, this.propName)) != null) {
                    return ImmutableList.of((Object)field);
                }
            } else {
                ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>(3);
                this.maybeAdd(elements, (IJavaElement)this.typeUtil.getField(beanType, this.propName));
                this.maybeAdd(elements, (IJavaElement)this.typeUtil.getSetter(beanType, this.propName));
                this.maybeAdd(elements, this.typeUtil.getGetter(beanType, this.propName));
                if (!elements.isEmpty()) {
                    return elements;
                }
            }
        }
        return ImmutableList.of();
    }

    private void maybeAdd(ArrayList<IJavaElement> elements, IJavaElement e) {
        if (e != null) {
            elements.add(e);
        }
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    protected IJavaProject getJavaProject() {
        return this.typeUtil.getJavaProject();
    }

    @Override
    protected String getType() {
        return this.typeUtil.niceTypeName(this.type);
    }

    @Override
    protected String getDeprecationReason() {
        if (this.deprecation != null) {
            return this.deprecation.getReason();
        }
        return null;
    }

    @Override
    protected String getId() {
        return this.id;
    }

    @Override
    protected String getDeprecationReplacement() {
        if (this.deprecation != null) {
            return this.deprecation.getReplacement();
        }
        return null;
    }
}

