/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;

public abstract class LazyProposalApplier
implements ProposalApplier {
    private ProposalApplier created = null;
    private Exception exception = null;

    protected abstract ProposalApplier create() throws Exception;

    public Point getSelection(IDocument document) throws Exception {
        this.ensureCreated();
        return this.created.getSelection(document);
    }

    public void apply(IDocument doc) throws Exception {
        this.ensureCreated();
        this.created.apply(doc);
    }

    private void ensureCreated() throws Exception {
        if (this.created == null && this.exception == null) {
            try {
                this.created = this.create();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

