/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.completions.JavaTypeNavigationHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.yaml.completions.AbstractPropertyProposal;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;

public class PropertyCompletionFactory
extends CompletionFactory {
    private DocumentContextFinder documentContextFinder;

    public CompletionFactory.ScoreableProposal property(IDocument doc, ProposalApplier applier, FuzzyMap.Match<PropertyInfo> prop, TypeUtil typeUtil) {
        return new PropertyProposal(doc, applier, prop, typeUtil);
    }

    public CompletionFactory.ScoreableProposal beanProperty(IDocument doc, final String contextProperty, final Type contextType, final String pattern, final TypedProperty property, final double score, ProposalApplier applier, final TypeUtil typeUtil) {
        AbstractPropertyProposal proposal = new AbstractPropertyProposal(doc, applier){
            private HoverInfo hoverInfo;

            public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
                if (this.hoverInfo == null) {
                    String prefix = contextProperty == null ? "" : String.valueOf(contextProperty) + ".";
                    this.hoverInfo = new JavaTypeNavigationHoverInfo(String.valueOf(prefix) + property.getName(), property.getName(), contextType, property.getType(), typeUtil);
                }
                return this.hoverInfo;
            }

            protected String getBaseDisplayString() {
                return property.getName();
            }

            protected String getHighlightPattern() {
                return pattern;
            }

            protected Type getType() {
                return property.getType();
            }

            public double getBaseScore() {
                return score;
            }

            protected String niceTypeName(YType type) {
                return typeUtil.niceTypeName((Type)type);
            }
        };
        if (property.isDeprecated()) {
            proposal.deprecate();
        }
        return proposal;
    }

    public PropertyCompletionFactory(DocumentContextFinder documentContextFinder) {
        this.documentContextFinder = documentContextFinder;
    }

    private class PropertyProposal
    extends AbstractPropertyProposal {
        private FuzzyMap.Match<PropertyInfo> match;
        private Type type;
        private TypeUtil typeUtil;

        public PropertyProposal(IDocument doc, ProposalApplier applier, FuzzyMap.Match<PropertyInfo> match, TypeUtil typeUtil) {
            super(doc, applier);
            this.typeUtil = typeUtil;
            this.match = match;
            if (((PropertyInfo)match.data).isDeprecated()) {
                this.deprecate();
            }
        }

        public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
            return new SpringPropertyHoverInfo(PropertyCompletionFactory.this.documentContextFinder.getJavaProject(this.fDoc), (PropertyInfo)this.match.data);
        }

        protected String getBaseDisplayString() {
            return ((PropertyInfo)this.match.data).getId();
        }

        public double getBaseScore() {
            return this.match.score;
        }

        protected Type getType() {
            if (this.type == null) {
                this.type = TypeParser.parse(((PropertyInfo)this.match.data).getType());
            }
            return this.type;
        }

        protected String getHighlightPattern() {
            return this.match.getPattern();
        }

        protected String niceTypeName(YType type) {
            return this.typeUtil.niceTypeName((Type)type);
        }
    }
}

