/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.completions.AbstractPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class SpringPropertyHoverInfo
extends AbstractPropertyHoverInfo {
    private static final String[] NO_ARGS = new String[0];
    private IJavaProject javaProject;
    private PropertyInfo data;

    public SpringPropertyHoverInfo(IJavaProject project, PropertyInfo data) {
        this.javaProject = project;
        this.data = data;
    }

    public PropertyInfo getElement() {
        return this.data;
    }

    public boolean canOpenDeclaration() {
        return this.getJavaElements() != null;
    }

    public List<IJavaElement> getJavaElements() {
        try {
            if (this.javaProject != null) {
                SpringPropertiesCompletionEngine.debug("javaProject = " + this.javaProject.getElementName());
                List<PropertyInfo.PropertySource> sources = this.getSources();
                SpringPropertiesCompletionEngine.debug("propertySources = " + sources);
                if (!sources.isEmpty()) {
                    ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
                    for (PropertyInfo.PropertySource source : sources) {
                        String typeName = source.getSourceType();
                        if (typeName == null) continue;
                        IType type = this.javaProject.findType(typeName);
                        IMethod method = null;
                        if (type != null) {
                            String methodSig = source.getSourceMethod();
                            method = methodSig != null ? this.getMethod(type, methodSig) : this.getSetter(type, this.getElement());
                        }
                        if (method != null) {
                            elements.add((IJavaElement)method);
                            continue;
                        }
                        if (type == null) continue;
                        elements.add((IJavaElement)type);
                    }
                    return elements;
                }
            } else {
                SpringPropertiesCompletionEngine.debug("javaProject = null");
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return Collections.emptyList();
    }

    private IMethod getSetter(IType type, PropertyInfo propertyInfo) {
        try {
            String propName = propertyInfo.getName();
            String setterName = "set" + Character.toUpperCase(propName.charAt(0)) + this.toCamelCase(propName.substring(1));
            String sloppySetterName = setterName.toLowerCase();
            IMethod sloppyMatch = null;
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                String mname = m.getElementName();
                if (setterName.equals(mname)) {
                    return m;
                }
                if (mname.toLowerCase().equals(sloppySetterName)) {
                    sloppyMatch = m;
                }
                ++n2;
            }
            return sloppyMatch;
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
            return null;
        }
    }

    private String toCamelCase(String name) {
        if (name.isEmpty()) {
            return name;
        }
        StringBuilder camel = new StringBuilder();
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '-') {
                if (++i < chars.length) {
                    camel.append(Character.toUpperCase(chars[i]));
                }
            } else {
                camel.append(chars[i]);
            }
            ++i;
        }
        return camel.toString();
    }

    public List<PropertyInfo.PropertySource> getSources() {
        return this.data.getSources();
    }

    private IMethod getMethod(IType type, String methodSig) throws JavaModelException {
        int nameEnd = methodSig.indexOf(40);
        String name = nameEnd >= 0 ? methodSig.substring(0, nameEnd) : methodSig;
        IMethod m = type.getMethod(name, NO_ARGS);
        if (m != null) {
            return m;
        }
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod meth = iMethodArray[n2];
            if (name.equals(meth.getElementName())) {
                return meth;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected Object getDefaultValue() {
        return this.data.getDefaultValue();
    }

    @Override
    protected IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    protected HtmlSnippet getDescription() {
        String desc = this.data.getDescription();
        if (StringUtil.hasText((String)desc)) {
            return HtmlSnippet.text((String)desc);
        }
        return null;
    }

    @Override
    protected String getType() {
        return this.data.getType();
    }

    @Override
    protected String getDeprecationReason() {
        return this.data.getDeprecationReason();
    }

    @Override
    protected String getId() {
        return this.data.getId();
    }

    @Override
    protected String getDeprecationReplacement() {
        return this.data.getDeprecationReplacement();
    }

    @Override
    protected boolean isDeprecated() {
        return this.data.isDeprecated();
    }
}

