/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;

public class BasicHintProvider
implements HintProvider {
    private IJavaProject javaProject;
    private ImmutableList<ValueHint> valueHints;
    private ValueProviderRegistry.ValueProviderStrategy valueProvider;

    public BasicHintProvider(IJavaProject javaProject, ImmutableList<ValueHint> valueHints, ValueProviderRegistry.ValueProviderStrategy valueProvider) {
        this.javaProject = javaProject;
        this.valueHints = valueHints;
        this.valueProvider = valueProvider;
    }

    public HintProvider traverse(YamlPathSegment s) throws Exception {
        return this;
    }

    @Override
    public List<StsValueHint> getValueHints(String query) {
        Collection<StsValueHint> provided;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (CollectionUtil.hasElements(this.valueHints)) {
            for (ValueHint hint : this.valueHints) {
                builder.add((Object)StsValueHint.create(hint));
            }
        }
        if (this.valueProvider != null && CollectionUtil.hasElements(provided = this.valueProvider.getValuesNow(this.javaProject, query))) {
            builder.addAll(provided);
        }
        return builder.build();
    }

    @Override
    public List<TypedProperty> getPropertyHints(String query) {
        return ImmutableList.of();
    }
}

