/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import java.time.Duration;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.Cache;
import org.springframework.ide.eclipse.boot.properties.editor.util.LimitedTimeCache;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class CachingValueProvider
implements ValueProviderRegistry.ValueProviderStrategy {
    private static final Duration DEFAULT_TIMEOUT;
    public static Duration TIMEOUT;
    private int MAX_RESULTS = 500;
    private Cache<Tuple2<String, String>, CacheEntry> cache = this.createCache();

    static {
        TIMEOUT = DEFAULT_TIMEOUT = Duration.ofMillis(1000L);
    }

    @Override
    public final Flux<StsValueHint> getValues(IJavaProject javaProject, String query) {
        Tuple2<String, String> key = this.key(javaProject, query);
        CacheEntry cached = this.cache.get(key);
        if (cached == null) {
            cached = new CacheEntry(query, this.getValuesIncremental(javaProject, query));
            this.cache.put(key, cached);
        }
        return cached.values;
    }

    private Flux<StsValueHint> getValuesIncremental(IJavaProject javaProject, String query) {
        String subquery = query;
        while (subquery.length() >= 1) {
            CacheEntry cached = this.cache.get(this.key(javaProject, subquery = subquery.substring(0, subquery.length() - 1)));
            if (cached == null) continue;
            System.out.println("cached " + subquery + ": " + cached);
            if (!cached.isComplete) continue;
            return cached.values.filter(hint -> 0.0 != FuzzyMatcher.matchScore((String)query, (String)hint.getValue().toString()));
        }
        return this.getValuesAsycn(javaProject, query);
    }

    protected abstract Flux<StsValueHint> getValuesAsycn(IJavaProject var1, String var2);

    private Tuple2<String, String> key(IJavaProject javaProject, String query) {
        return Tuples.of((Object)(javaProject == null ? null : javaProject.getElementName()), (Object)query);
    }

    protected <K, V> Cache<K, V> createCache() {
        return new LimitedTimeCache(Duration.ofMinutes(1L));
    }

    public static void restoreDefaults() {
        TIMEOUT = DEFAULT_TIMEOUT;
    }

    private class CacheEntry {
        boolean isComplete = false;
        int count = 0;
        Flux<StsValueHint> values;

        public CacheEntry(String query, Flux<StsValueHint> producer) {
            this.values = producer.take((long)CachingValueProvider.this.MAX_RESULTS).cache(CachingValueProvider.this.MAX_RESULTS);
            this.values.subscribe();
        }

        public String toString() {
            return "CacheEntry [isComplete=" + this.isComplete + ", count=" + this.count + "]";
        }
    }
}

