/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.JdtSearchingValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.LimitedTimeCache;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.async.FluxJdtSearch;
import reactor.core.publisher.Mono;

public class ClassReferenceProvider
extends JdtSearchingValueProvider {
    private static final boolean DEFAULT_CONCRETE = true;
    private static final ClassReferenceProvider UNTARGETTED_INSTANCE = new ClassReferenceProvider(null, true);
    public static final Function<Map<String, Object>, ValueProviderRegistry.ValueProviderStrategy> FACTORY = LimitedTimeCache.applyOn(Duration.ofMinutes(1L), params -> {
        String target = ClassReferenceProvider.getTarget(params);
        Boolean concrete = ClassReferenceProvider.getConcrete(params);
        if (target != null || concrete != null) {
            if (concrete == null) {
                concrete = true;
            }
            return new ClassReferenceProvider(target, concrete);
        }
        return UNTARGETTED_INSTANCE;
    });
    private String target;
    private boolean concrete;

    private static String getTarget(Map<String, Object> params) {
        String target;
        Object obj;
        if (params != null && (obj = params.get("target")) instanceof String && StringUtil.hasText((String)(target = (String)obj))) {
            return target;
        }
        return null;
    }

    private Mono<StsValueHint> filterConcreteTypes(SearchMatch match) {
        Object element = match.getElement();
        if (element instanceof IType) {
            IType type = (IType)element;
            if (ClassReferenceProvider.isAbstract(type)) {
                return Mono.empty();
            }
            return Mono.justOrEmpty((Object)this.hint((IJavaElement)type));
        }
        return Mono.empty();
    }

    private static boolean isAbstract(IType type) {
        try {
            return type.isInterface() || Flags.isAbstract((int)type.getFlags());
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return false;
        }
    }

    @Override
    protected Function<SearchMatch, Mono<StsValueHint>> getPostProcessor() {
        if (this.concrete) {
            return this::filterConcreteTypes;
        }
        return super.getPostProcessor();
    }

    private static Boolean getConcrete(Map<String, Object> params) {
        try {
            if (params != null) {
                Object obj = params.get("concrete");
                if (obj instanceof String) {
                    String concrete = (String)obj;
                    return Boolean.valueOf(concrete);
                }
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    private ClassReferenceProvider(String target, boolean concrete) {
        this.target = target;
        this.concrete = concrete;
    }

    @Override
    protected SearchPattern toPattern(String query) {
        String wildcardedQuery = ClassReferenceProvider.toWildCardPattern(query);
        return ClassReferenceProvider.toTypePattern(wildcardedQuery);
    }

    @Override
    public IJavaSearchScope getScope(IJavaProject project) throws JavaModelException {
        if (this.target != null) {
            IType type = this.getTargetType(project);
            if (type != null) {
                boolean onlySubtypes = true;
                boolean includeFocusType = true;
                WorkingCopyOwner owner = null;
                return SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)type, (boolean)onlySubtypes, (boolean)includeFocusType, owner);
            }
            return null;
        }
        return FluxJdtSearch.searchScope((IJavaProject)project);
    }

    private IType getTargetType(IJavaProject project) {
        try {
            if (this.target != null) {
                return project.findType(this.target);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }
}

