/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import com.google.common.collect.ImmutableSet;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.ide.eclipse.boot.util.Log;

public class DeprecationUtil {
    private static final ImmutableSet<String> DEPRECATED_ANOT_NAMES = ImmutableSet.of((Object)"org.springframework.boot.context.properties.DeprecatedConfigurationProperty", (Object)"DeprecatedConfigurationProperty", (Object)"java.lang.Deprecated", (Object)"Deprecated");

    public static Deprecation extract(IJavaElement je) {
        if (je instanceof IAnnotatable) {
            return DeprecationUtil.extract((IAnnotatable)je);
        }
        return null;
    }

    private static Deprecation extract(IAnnotatable m) {
        try {
            IAnnotation[] iAnnotationArray = m.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation a = iAnnotationArray[n2];
                if (DEPRECATED_ANOT_NAMES.contains((Object)a.getElementName())) {
                    Deprecation d = new Deprecation();
                    IMemberValuePair[] iMemberValuePairArray = a.getMemberValuePairs();
                    int n3 = iMemberValuePairArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemberValuePair pair = iMemberValuePairArray[n4];
                        String name = pair.getMemberName();
                        if (name.equals("reason")) {
                            d.setReason((String)pair.getValue());
                        } else if (name.equals("replacement")) {
                            d.setReplacement((String)pair.getValue());
                        }
                        ++n4;
                    }
                    return d;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }
}

