/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.BasicHintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;

public class HintProviders {
    public static final HintProvider NULL = new HintProvider(){

        public HintProvider traverse(YamlPathSegment s) throws Exception {
            return NULL;
        }

        @Override
        public List<StsValueHint> getValueHints(String query) {
            return ImmutableList.of();
        }

        @Override
        public List<TypedProperty> getPropertyHints(String query) {
            return ImmutableList.of();
        }
    };

    public static HintProvider basic(IJavaProject jp, ImmutableList<ValueHint> valueHints, ValueProviderRegistry.ValueProviderStrategy valueProvider) {
        if (!CollectionUtil.hasElements(valueHints) && valueProvider == null) {
            return NULL;
        }
        return new BasicHintProvider(jp, valueHints, valueProvider);
    }

    public static HintProvider forDomainAt(final HintProvider valueHints, final int dim) {
        if (HintProviders.isNull(valueHints)) {
            return NULL;
        }
        if (dim == 0) {
            return HintProviders.forHere(valueHints);
        }
        return new HintProvider(){

            public HintProvider traverse(YamlPathSegment s) throws Exception {
                switch (s.getType()) {
                    case VAL_AT_KEY: 
                    case VAL_AT_INDEX: {
                        return HintProviders.forDomainAt(valueHints, dim - 1);
                    }
                }
                return NULL;
            }

            @Override
            public List<StsValueHint> getValueHints(String query) {
                return ImmutableList.of();
            }

            @Override
            public List<TypedProperty> getPropertyHints(String query) {
                return ImmutableList.of();
            }
        };
    }

    public static HintProvider forHere(final HintProvider valueHints) {
        if (HintProviders.isNull(valueHints)) {
            return NULL;
        }
        return new HintProvider(){

            public HintProvider traverse(YamlPathSegment s) throws Exception {
                return NULL;
            }

            @Override
            public List<StsValueHint> getValueHints(String query) {
                return valueHints.getValueHints(query);
            }

            @Override
            public List<TypedProperty> getPropertyHints(String query) {
                return ImmutableList.of();
            }
        };
    }

    public static HintProvider forAllValueContexts(final HintProvider valueProvider) {
        if (HintProviders.isNull(valueProvider)) {
            return NULL;
        }
        return new HintProvider(){

            public HintProvider traverse(YamlPathSegment s) throws Exception {
                switch (s.getType()) {
                    case VAL_AT_KEY: 
                    case VAL_AT_INDEX: {
                        return this;
                    }
                }
                return NULL;
            }

            @Override
            public List<StsValueHint> getValueHints(String query) {
                return valueProvider.getValueHints(query);
            }

            @Override
            public List<TypedProperty> getPropertyHints(String query) {
                return ImmutableList.of();
            }
        };
    }

    public static boolean isNull(HintProvider p) {
        return p == NULL || p == null;
    }

    public static HintProvider forMap(HintProvider _keyProvider, HintProvider _valueProvider, final Type valueType, final boolean dimensionAware) {
        final HintProvider keyProvider = HintProviders.notNull(_keyProvider);
        final HintProvider valueProvider = HintProviders.notNull(_valueProvider);
        if (HintProviders.isNull(keyProvider) && HintProviders.isNull(valueProvider)) {
            return NULL;
        }
        return new HintProvider(){

            public HintProvider traverse(YamlPathSegment s) throws Exception {
                switch (s.getType()) {
                    case VAL_AT_KEY: 
                    case VAL_AT_INDEX: {
                        if (dimensionAware) {
                            return HintProviders.forHere(valueProvider);
                        }
                        return HintProviders.forAllValueContexts(valueProvider);
                    }
                }
                return NULL;
            }

            @Override
            public List<StsValueHint> getValueHints(String query) {
                if (dimensionAware) {
                    return ImmutableList.of();
                }
                return valueProvider.getValueHints(query);
            }

            @Override
            public List<TypedProperty> getPropertyHints(String query) {
                List<StsValueHint> keyHints = keyProvider.getValueHints(query);
                if (CollectionUtil.hasElements(keyHints)) {
                    ArrayList<TypedProperty> props = new ArrayList<TypedProperty>(keyHints.size());
                    for (StsValueHint keyHint : keyHints) {
                        String key = keyHint.getValue();
                        if (!(key instanceof String)) continue;
                        props.add(new TypedProperty(key, valueType, null));
                    }
                    return props;
                }
                return ImmutableList.of();
            }
        };
    }

    private static HintProvider notNull(HintProvider p) {
        if (p == null) {
            return NULL;
        }
        return p;
    }
}

