/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import java.util.function.Function;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.CachingValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import org.springsource.ide.eclipse.commons.frameworks.core.async.FluxJdtSearch;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class JdtSearchingValueProvider
extends CachingValueProvider {
    public static String toWildCardPattern(String query) {
        StringBuilder builder = new StringBuilder("*");
        char[] cArray = query.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            builder.append(c);
            builder.append('*');
            ++n2;
        }
        return builder.toString();
    }

    public static SearchPattern toPackagePattern(String wildCardedQuery) {
        int searchFor = 2;
        int limitTo = 0;
        int matchRule = 2;
        return SearchPattern.createPattern((String)wildCardedQuery, (int)searchFor, (int)limitTo, (int)matchRule);
    }

    public static SearchPattern toClassPattern(String wildCardedQuery) {
        int searchFor = 5;
        int limitTo = 0;
        int matchRule = 2;
        return SearchPattern.createPattern((String)wildCardedQuery, (int)searchFor, (int)limitTo, (int)matchRule);
    }

    public static SearchPattern toTypePattern(String wildCardedQuery) {
        int searchFor = 0;
        int limitTo = 0;
        int matchRule = 2;
        return SearchPattern.createPattern((String)wildCardedQuery, (int)searchFor, (int)limitTo, (int)matchRule);
    }

    protected String asStringValue(IJavaElement element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getFullyQualifiedName();
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment pkg = (IPackageFragment)element;
            return pkg.getElementName();
        }
        return null;
    }

    protected StsValueHint hint(IJavaElement e) {
        String fqName = this.asStringValue(e);
        return fqName == null ? null : StsValueHint.create(fqName, e);
    }

    protected abstract SearchPattern toPattern(String var1);

    protected IJavaSearchScope getScope(IJavaProject javaProject) throws JavaModelException {
        return FluxJdtSearch.searchScope((IJavaProject)javaProject);
    }

    @Override
    public Flux<StsValueHint> getValuesAsycn(IJavaProject javaProject, String query) {
        try {
            return new FluxJdtSearch().scope(this.getScope(javaProject)).pattern(this.toPattern(query)).search().flatMap(this.getPostProcessor()).filter(hint -> 0.0 != FuzzyMatcher.matchScore((String)query, (String)hint.getValue())).distinct(StsValueHint::getValue);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    protected Function<SearchMatch, Mono<StsValueHint>> getPostProcessor() {
        return match -> {
            Object e = match.getElement();
            if (e instanceof IJavaElement) {
                return Mono.justOrEmpty((Object)this.hint((IJavaElement)e));
            }
            return Mono.empty();
        };
    }
}

