/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.boot.configurationmetadata.ValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProviders;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;

public class PropertyInfo {
    private final String id;
    private String type;
    private final String name;
    private final Object defaultValue;
    private final String description;
    private List<PropertySource> sources;
    private Deprecation deprecation;
    private ImmutableList<ValueHint> valueHints;
    private ImmutableList<ValueHint> keyHints;
    private ValueProviderRegistry.ValueProviderStrategy valueProvider;
    private ValueProviderRegistry.ValueProviderStrategy keyProvider;

    public PropertyInfo(String id, String type, String name, Object defaultValue, String description, Deprecation deprecation, List<ValueHint> valueHints, List<ValueHint> keyHints, ValueProviderRegistry.ValueProviderStrategy valueProvider, ValueProviderRegistry.ValueProviderStrategy keyProvider, List<PropertySource> sources) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.deprecation = deprecation;
        this.valueHints = valueHints == null ? null : ImmutableList.copyOf(valueHints);
        this.keyHints = keyHints == null ? null : ImmutableList.copyOf(keyHints);
        this.valueProvider = valueProvider;
        this.keyProvider = keyProvider;
        this.sources = sources;
    }

    public PropertyInfo(ValueProviderRegistry valueProviders, ConfigurationMetadataProperty prop) {
        this(prop.getId(), prop.getType(), prop.getName(), prop.getDefaultValue(), prop.getDescription(), prop.getDeprecation(), prop.getHints().getValueHints(), prop.getHints().getKeyHints(), valueProviders.resolve(prop.getHints().getValueProviders()), valueProviders.resolve(prop.getHints().getKeyProviders()), null);
        for (ValueProvider h : prop.getHints().getValueProviders()) {
            if (!h.getName().equals("handle-as")) continue;
            this.handleAs(h.getParameters().get("target"));
        }
    }

    private void handleAs(Object targetObject) {
        if (targetObject instanceof String) {
            this.type = (String)targetObject;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public HintProvider getHints(TypeUtil typeUtil, boolean dimensionAware) {
        Type type = TypeParser.parse(this.type);
        if (TypeUtil.isMap(type)) {
            return HintProviders.forMap(this.keyHints(typeUtil), this.valueHints(typeUtil), TypeUtil.getDomainType(type), dimensionAware);
        }
        if (TypeUtil.isSequencable(type)) {
            if (dimensionAware) {
                if (TypeUtil.isSequencable(type)) {
                    return HintProviders.forDomainAt(this.valueHints(typeUtil), TypeUtil.getDimensionality(type));
                }
                return HintProviders.forHere(this.valueHints(typeUtil));
            }
            return HintProviders.forAllValueContexts(this.valueHints(typeUtil));
        }
        return HintProviders.forHere(this.valueHints(typeUtil));
    }

    private HintProvider keyHints(TypeUtil typeUtil) {
        return HintProviders.basic(typeUtil.getJavaProject(), this.keyHints, this.keyProvider);
    }

    private HintProvider valueHints(TypeUtil typeUtil) {
        return HintProviders.basic(typeUtil.getJavaProject(), this.valueHints, this.valueProvider);
    }

    public List<PropertySource> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "PropertyInfo(" + this.getId() + ")";
    }

    public void addSource(ConfigurationMetadataSource source) {
        if (this.sources == null) {
            this.sources = new ArrayList<PropertySource>();
        }
        this.sources.add(new PropertySource(source));
    }

    public PropertyInfo withId(String alias) {
        if (alias.equals(this.id)) {
            return this;
        }
        return new PropertyInfo(alias, this.type, this.name, this.defaultValue, this.description, this.deprecation, (List<ValueHint>)this.valueHints, (List<ValueHint>)this.keyHints, this.valueProvider, this.keyProvider, this.sources);
    }

    public void setDeprecation(Deprecation d) {
        this.deprecation = d;
    }

    public boolean isDeprecated() {
        return this.deprecation != null;
    }

    public String getDeprecationReason() {
        return this.deprecation == null ? null : this.deprecation.getReason();
    }

    public String getDeprecationReplacement() {
        return this.deprecation == null ? null : this.deprecation.getReplacement();
    }

    public void addValueHints(List<ValueHint> hints) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.valueHints);
        builder.addAll(hints);
        this.valueHints = builder.build();
    }

    public void addKeyHints(List<ValueHint> hints) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.keyHints);
        builder.addAll(hints);
        this.keyHints = builder.build();
    }

    public static class PropertySource {
        private final String sourceType;
        private final String sourceMethod;

        public PropertySource(ConfigurationMetadataSource source) {
            String st = source.getSourceType();
            this.sourceType = st != null ? st : source.getType();
            this.sourceMethod = source.getSourceMethod();
        }

        public String toString() {
            return String.valueOf(this.sourceType) + "::" + this.sourceMethod;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getSourceMethod() {
            return this.sourceMethod;
        }
    }
}

