/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import javax.inject.Provider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.DeprecationUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class StsValueHint {
    private static final HtmlSnippet EMPTY_DESCRIPTION = HtmlSnippet.italic((String)"No description");
    private static final Provider<HtmlSnippet> EMPTY_DESCRIPTION_PROVIDER = () -> EMPTY_DESCRIPTION;
    private final String value;
    private final Provider<HtmlSnippet> description;
    private final Deprecation deprecation;

    private StsValueHint(String value, Provider<HtmlSnippet> description, Deprecation deprecation) {
        this.value = value == null ? "null" : value.toString();
        Assert.isLegal((!this.value.startsWith("StsValueHint") ? 1 : 0) != 0);
        this.description = description;
        this.deprecation = deprecation;
    }

    public static StsValueHint create(String value, final IJavaElement javaElement) {
        return new StsValueHint(value, StsValueHint.javaDocSnippet(javaElement), DeprecationUtil.extract(javaElement)){

            @Override
            public IJavaElement getJavaElement() {
                return javaElement;
            }
        };
    }

    public static StsValueHint create(String value) {
        return new StsValueHint(value, EMPTY_DESCRIPTION_PROVIDER, null);
    }

    public static StsValueHint create(ValueHint hint) {
        return new StsValueHint("" + hint.getValue(), StsValueHint.textSnippet(hint.getDescription()), null);
    }

    public static StsValueHint className(String fqName, TypeUtil typeUtil) {
        try {
            IType type;
            IJavaProject jp = typeUtil.getJavaProject();
            if (jp != null && (type = jp.findType(fqName, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return StsValueHint.create(type);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static StsValueHint create(final IType klass) {
        return new StsValueHint(klass.getFullyQualifiedName(), StsValueHint.javaDocSnippet((IJavaElement)klass), DeprecationUtil.extract((IJavaElement)klass)){

            @Override
            public IJavaElement getJavaElement() {
                return klass;
            }
        };
    }

    private static Provider<HtmlSnippet> textSnippet(String description) {
        if (StringUtil.hasText((String)description)) {
            return () -> HtmlSnippet.text((String)description);
        }
        return EMPTY_DESCRIPTION_PROVIDER;
    }

    public String getValue() {
        return this.value;
    }

    public HtmlSnippet getDescription() {
        return (HtmlSnippet)this.description.get();
    }

    public Provider<HtmlSnippet> getDescriptionProvider() {
        return this.description;
    }

    public static Provider<HtmlSnippet> javaDocSnippet(IJavaElement je) {
        return () -> {
            try {
                String htmlText = JavadocContentAccess2.getHTMLContent((IJavaElement)je, (boolean)true);
                if (StringUtil.hasText((String)htmlText)) {
                    return HtmlSnippet.raw((String)htmlText);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            return EMPTY_DESCRIPTION;
        };
    }

    public String toString() {
        return "StsValueHint(" + this.value + ")";
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public StsValueHint prefixWith(String prefix) {
        final StsValueHint it = this;
        return new StsValueHint(String.valueOf(prefix) + this.getValue(), this.description, this.deprecation){

            @Override
            public IJavaElement getJavaElement() {
                return it.getJavaElement();
            }
        };
    }

    /* synthetic */ StsValueHint(String string, Provider provider, Deprecation deprecation, StsValueHint stsValueHint) {
        this(string, (Provider<HtmlSnippet>)provider, deprecation);
    }
}

