/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.boot.configurationmetadata.ValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.CachingValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ClassReferenceProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.LoggerNameProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import reactor.core.publisher.Flux;

public class ValueProviderRegistry {
    private static ValueProviderRegistry DEFAULT;
    private Map<String, Function<Map<String, Object>, ValueProviderStrategy>> registry = new HashMap<String, Function<Map<String, Object>, ValueProviderStrategy>>();

    public static synchronized ValueProviderRegistry getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ValueProviderRegistry();
            DEFAULT.initializeDefaults(DEFAULT);
        }
        return DEFAULT;
    }

    protected void initializeDefaults(ValueProviderRegistry r) {
        this.def("logger-name", LoggerNameProvider.FACTORY);
        this.def("class-reference", ClassReferenceProvider.FACTORY);
    }

    public void def(String id, Function<Map<String, Object>, ValueProviderStrategy> algo) {
        Assert.isLegal((!this.registry.containsKey(id) ? 1 : 0) != 0);
        this.registry.put(id, algo);
    }

    public ValueProviderStrategy resolve(List<ValueProvider> providerDescriptors) {
        if (CollectionUtil.hasElements(providerDescriptors)) {
            for (ValueProvider descriptor : providerDescriptors) {
                Function<Map<String, Object>, ValueProviderStrategy> factory = this.registry.get(descriptor.getName());
                if (factory == null) continue;
                Map<String, Object> params = descriptor.getParameters();
                return factory.apply(params);
            }
        }
        return null;
    }

    public static interface ValueProviderStrategy {
        public Flux<StsValueHint> getValues(IJavaProject var1, String var2);

        default public Collection<StsValueHint> getValuesNow(IJavaProject javaProject, String query) {
            return (Collection)this.getValues(javaProject, query).take(CachingValueProvider.TIMEOUT).collectList().block();
        }
    }
}

