/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.preferences;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.ProblemSeverityPreferencesUtil;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.util.CheckboxWidget;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public abstract class AbstractPropertiesEditorPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IProject project;
    private LiveVariable<Boolean> enablePreferences = new LiveVariable((Object)true);
    private static final Comparator<SpringPropertiesProblemType> PROBLEM_TYPE_COMPARATOR = new Comparator<SpringPropertiesProblemType>(){

        @Override
        public int compare(SpringPropertiesProblemType o1, SpringPropertiesProblemType o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };
    private static final String[][] SEVERITY_NAMES_AND_VALUES = new String[][]{{"Error", ProblemSeverity.ERROR.toString()}, {"Warning", ProblemSeverity.WARNING.toString()}, {"Ignore", ProblemSeverity.IGNORE.toString()}};

    protected AbstractPropertiesEditorPreferencesPage() {
        super(1);
        ProblemSeverityPreferencesUtil.initializeDefaults();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SpringPropertiesEditorPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        SpringPropertiesProblemType[] problemTypes = this.getProblemTypes();
        Arrays.sort(problemTypes, PROBLEM_TYPE_COMPARATOR);
        SpringPropertiesProblemType[] springPropertiesProblemTypeArray = problemTypes;
        int n = problemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SpringPropertiesProblemType problemType = springPropertiesProblemTypeArray[n2];
            ComboFieldEditor field = new ComboFieldEditor(ProblemSeverityPreferencesUtil.getPreferenceName(problemType), problemType.getLabel(), SEVERITY_NAMES_AND_VALUES, this.getFieldEditorParent());
            this.setTooltip(field, problemType.getDescription());
            this.addField((FieldEditor)field);
            ++n2;
        }
    }

    protected Control createContents(Composite parent) {
        if (this.isProjectPropertyPage()) {
            return this.createProjectPageContent(parent);
        }
        return super.createContents(parent);
    }

    private Control createProjectPageContent(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        CheckboxWidget enablePreferencesCheckbox = new CheckboxWidget(page, this.enablePreferences);
        enablePreferencesCheckbox.setText("Enable project-specific settings");
        final Control preferencesControl = super.createContents(page);
        this.enablePreferences.addListener((ValueListener)new UIValueListener<Boolean>(){
            private ControlEnableState fBlockEnableState;

            protected void enablePreferenceContent(boolean enable) {
                if (enable) {
                    if (this.fBlockEnableState != null) {
                        this.fBlockEnableState.restore();
                        this.fBlockEnableState = null;
                    }
                } else if (this.fBlockEnableState == null) {
                    this.fBlockEnableState = ControlEnableState.disable((Control)preferencesControl);
                }
            }

            protected void uiGotValue(LiveExpression<Boolean> exp, Boolean enable) {
                if (enable != null) {
                    this.enablePreferenceContent(enable);
                }
            }
        });
        return page;
    }

    private boolean isProjectPropertyPage() {
        return this.project != null;
    }

    protected abstract SpringPropertiesProblemType[] getProblemTypes();

    protected void setTooltip(ComboFieldEditor field, String tooltip) {
        field.getLabelControl(this.getFieldEditorParent()).setToolTipText(tooltip);
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IProject.class);
        if (this.project != null) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), "org.springframework.ide.eclipse.boot.properties.editor"));
            this.enablePreferences.setValue((Object)this.getPreferenceStore().getBoolean(this.getEnableProjectPreferencesKey()));
        }
    }

    public boolean performOk() {
        if (this.isProjectPropertyPage()) {
            this.getPreferenceStore().setValue(this.getEnableProjectPreferencesKey(), ((Boolean)this.enablePreferences.getValue()).booleanValue());
        }
        return super.performOk();
    }

    protected void performDefaults() {
        if (this.isProjectPropertyPage()) {
            this.enablePreferences.setValue((Object)this.getPreferenceStore().getDefaultBoolean(this.getEnableProjectPreferencesKey()));
        }
        super.performDefaults();
    }

    protected abstract String getEnableProjectPreferencesKey();
}

