/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.ProblemSeverityPreferencesUtil;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.SeverityProvider;

public class PreferencesBasedSeverityProvider
implements SeverityProvider {
    private EditorType editorType;
    private IPreferenceStore projectPrefs;
    private IPreferenceStore workspacePrefs;
    private Map<ProblemType, ProblemSeverity> cache = null;

    public PreferencesBasedSeverityProvider(IPreferenceStore projectPrefs, IPreferenceStore workspacePrefs, EditorType editorType) {
        this.projectPrefs = projectPrefs;
        this.workspacePrefs = workspacePrefs;
        this.editorType = editorType;
    }

    public ProblemSeverity getSeverity(ReconcileProblem problem) {
        return this.getSeverity(problem.getType());
    }

    private synchronized ProblemSeverity getSeverity(ProblemType problemType) {
        ProblemSeverity existing;
        if (this.cache == null) {
            this.cache = new HashMap<ProblemType, ProblemSeverity>();
        }
        if ((existing = this.cache.get(problemType)) == null) {
            existing = ProblemSeverityPreferencesUtil.getSeverity(this.getPrefs(), problemType);
            this.cache.put(problemType, existing);
        }
        return existing;
    }

    protected IPreferenceStore getPrefs() {
        if (this.useProjectPreferences()) {
            return this.projectPrefs;
        }
        return this.workspacePrefs;
    }

    private boolean useProjectPreferences() {
        if (this.projectPrefs != null) {
            return ProblemSeverityPreferencesUtil.projectPreferencesEnabled(this.projectPrefs, this.editorType);
        }
        return false;
    }

    public synchronized void startReconciling() {
        this.cache = null;
    }
}

