/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemType;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class ProblemSeverityPreferencesUtil {
    public static final String PREFERENCE_PREFIX = "spring.properties.editor.problem.";

    public static final String ENABLE_PROJECT_PREFERENCES(EditorType et) {
        return PREFERENCE_PREFIX + (Object)((Object)et) + ".project.prefs.enabled";
    }

    public static void initializeDefaults() {
        IEclipsePreferences defaults = SpringPropertiesEditorPlugin.getDefault().getDefaultPreferences();
        SpringPropertiesProblemType[] springPropertiesProblemTypeArray = SpringPropertiesProblemType.values();
        int n = springPropertiesProblemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpringPropertiesProblemType problemType = springPropertiesProblemTypeArray[n2];
            defaults.put(ProblemSeverityPreferencesUtil.getPreferenceName(problemType), problemType.getDefaultSeverity().toString());
            ++n2;
        }
        try {
            defaults.flush();
        }
        catch (BackingStoreException e) {
            BootActivator.log((Throwable)e);
        }
    }

    public static String getPreferenceName(ProblemType problemType) {
        return PREFERENCE_PREFIX + problemType.toString();
    }

    public static ProblemSeverity getSeverity(IPreferenceStore prefs, ProblemType problemType) {
        String value = prefs.getString(ProblemSeverityPreferencesUtil.getPreferenceName(problemType));
        try {
            if (StringUtil.hasText((String)value)) {
                return ProblemSeverity.valueOf((String)value);
            }
        }
        catch (Exception exception) {}
        return problemType.getDefaultSeverity();
    }

    public static void setSeverity(IPreferenceStore prefs, ProblemType problemType, ProblemSeverity severity) {
        prefs.setValue(ProblemSeverityPreferencesUtil.getPreferenceName(problemType), severity.toString());
    }

    public static boolean projectPreferencesEnabled(IPreferenceStore projectPrefs, EditorType et) {
        return projectPrefs.getBoolean(ProblemSeverityPreferencesUtil.ENABLE_PROJECT_PREFERENCES(et));
    }

    public static void enableProjectPrefs(IPreferenceStore projectPrefs, EditorType et, boolean enable) {
        projectPrefs.setValue(ProblemSeverityPreferencesUtil.ENABLE_PROJECT_PREFERENCES(et), enable);
    }

    public static void save(IPreferenceStore preferences) {
        if (preferences.needsSaving() && preferences instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)preferences).save();
            }
            catch (IOException e) {
                BootActivator.log((Throwable)e);
            }
        }
    }
}

