/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.quickfix;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.ProblemSeverityPreferencesUtil;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;

public class IgnoreProblemTypeInProjectQuickfix
implements ICompletionProposal {
    private SpringPropertiesProblemType problemType;
    private IPreferenceStore workspacePrefs;
    private IPreferenceStore projectPrefs;
    private IProject project;

    public IgnoreProblemTypeInProjectQuickfix(QuickfixContext context, SpringPropertiesProblemType type) {
        this.project = context.getProject();
        this.workspacePrefs = context.getWorkspacePreferences();
        this.projectPrefs = context.getProjectPreferences();
        this.problemType = type;
    }

    public void apply(IDocument document) {
        EditorType et = this.problemType.getEditorType();
        if (!ProblemSeverityPreferencesUtil.projectPreferencesEnabled(this.projectPrefs, et)) {
            SpringPropertiesProblemType[] springPropertiesProblemTypeArray = SpringPropertiesProblemType.FOR(et);
            int n = springPropertiesProblemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemSeverity currentProjectValue;
                SpringPropertiesProblemType problemType = springPropertiesProblemTypeArray[n2];
                ProblemSeverity currentEffectiveValue = ProblemSeverityPreferencesUtil.getSeverity(this.workspacePrefs, problemType);
                if (!currentEffectiveValue.equals((Object)(currentProjectValue = ProblemSeverityPreferencesUtil.getSeverity(this.projectPrefs, problemType)))) {
                    ProblemSeverityPreferencesUtil.setSeverity(this.projectPrefs, problemType, currentEffectiveValue);
                }
                ++n2;
            }
            ProblemSeverityPreferencesUtil.enableProjectPrefs(this.projectPrefs, et, true);
        }
        ProblemSeverityPreferencesUtil.setSeverity(this.projectPrefs, this.problemType, ProblemSeverity.IGNORE);
        ProblemSeverityPreferencesUtil.save(this.projectPrefs);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "Sets problem severity preference for problems of type '" + this.problemType.getLabel() + "' to 'Ignore' in project '" + this.project.getName() + "'.";
    }

    public String getDisplayString() {
        return "Ignore '" + this.problemType.getLabel() + "' in project.";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.never_translate.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

