/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.quickfix;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.ProblemSeverityPreferencesUtil;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;

public class IgnoreProblemTypeInWorkspaceQuickfix
implements ICompletionProposal {
    private SpringPropertiesProblemType problemType;
    private IPreferenceStore preferences;

    public IgnoreProblemTypeInWorkspaceQuickfix(IPreferenceStore preferences, SpringPropertiesProblemType type) {
        this.preferences = preferences;
        this.problemType = type;
    }

    public void apply(IDocument document) {
        ProblemSeverityPreferencesUtil.setSeverity(this.preferences, this.problemType, ProblemSeverity.IGNORE);
        ProblemSeverityPreferencesUtil.save(this.preferences);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "Globally sets problem severity preference for problems of type '" + this.problemType.getLabel() + "' to 'Ignore'. ";
    }

    public String getDisplayString() {
        return "Ignore '" + this.problemType.getLabel() + "' in workspace.";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.never_translate.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

