/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.quickfix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.springframework.ide.eclipse.org.json.JSONArray;
import org.springframework.ide.eclipse.org.json.JSONObject;
import org.springsource.ide.eclipse.commons.frameworks.core.util.IOUtil;

public class MetaDataManipulator {
    private static final String INITIAL_CONTENT = "{\"properties\": [\n]}";
    private static String ENCODING = "UTF8";
    private ContentStore file;
    private Content fContent;
    private String fNewline;
    private int indentFactor = 2;

    public MetaDataManipulator(final IFile file) {
        this(new ContentStore(){

            @Override
            public InputStream getContents() throws Exception {
                return file.getContents();
            }

            @Override
            public void setContents(InputStream inputStream) throws Exception {
                file.setContents(inputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public MetaDataManipulator(ContentStore contentStore) {
        this.file = contentStore;
    }

    private Content getContent() throws Exception {
        if (this.fContent == null) {
            this.fContent = this.readContent(this.file, ENCODING);
        }
        return this.fContent;
    }

    private Content readContent(ContentStore file, String encoding) throws Exception {
        Document d = this.readDocument(file, encoding);
        if (this.isEmpty(d)) {
            JSONObject o = this.initialContent();
            return new ParsedContent(o);
        }
        try {
            return new ParsedContent(new JSONObject(d.get()));
        }
        catch (Exception exception) {
            return new RawContent(d);
        }
    }

    private Document readDocument(ContentStore file, String encoding) throws Exception {
        try (InputStream data = file.getContents();){
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            IOUtil.pipe((InputStream)data, (OutputStream)bytes);
            Document document = new Document(new String(bytes.toByteArray(), encoding));
            return document;
        }
    }

    public void addDefaultInfo(String propertyName) throws Exception {
        this.getContent().addProperty(this.createDefaultData(propertyName));
    }

    private JSONObject createDefaultData(String propertyName) throws Exception {
        JSONObject obj = new JSONObject(new LinkedHashMap());
        obj.put("name", propertyName);
        obj.put("type", String.class.getName());
        obj.put("description", "A description for '" + propertyName + "'");
        return obj;
    }

    private JSONObject initialContent() throws Exception {
        return new JSONObject(INITIAL_CONTENT);
    }

    private boolean isEmpty(Document d) throws Exception {
        int len = d.getLength();
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(d.getChar(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void save() throws Exception {
        this.file.setContents(this.toInputStream(this.getContent()));
    }

    private InputStream toInputStream(Content content) throws Exception {
        return new ByteArrayInputStream(content.toString().getBytes(ENCODING));
    }

    public boolean isReliable() throws Exception {
        return this.getContent() instanceof ParsedContent;
    }

    private abstract class Content {
        private Content() {
        }

        public abstract String toString();

        public abstract void addProperty(JSONObject var1) throws Exception;
    }

    public static interface ContentStore {
        public InputStream getContents() throws Exception;

        public void setContents(InputStream var1) throws Exception;
    }

    private class ParsedContent
    extends Content {
        private JSONObject object;

        public ParsedContent(JSONObject o) {
            this.object = o;
        }

        @Override
        public String toString() {
            return this.object.toString(MetaDataManipulator.this.indentFactor);
        }

        @Override
        public void addProperty(JSONObject propertyData) throws Exception {
            JSONArray properties = this.object.getJSONArray("properties");
            properties.put(properties.length(), (Object)propertyData);
        }
    }

    private class RawContent
    extends Content {
        private Document doc;

        public RawContent(Document doc) {
            this.doc = doc;
        }

        @Override
        public String toString() {
            return this.doc.get();
        }

        @Override
        public void addProperty(JSONObject propertyData) throws Exception {
            String newline = this.getNewline();
            int insertAt = this.findLast(']');
            if (insertAt < 0) {
                insertAt = this.doc.getLength();
            }
            this.insert(insertAt, newline);
            this.insert(insertAt, propertyData.toString(MetaDataManipulator.this.indentFactor));
            int insertComma = this.findInsertCommaPos(insertAt);
            if (insertComma >= 0) {
                this.insert(insertComma, ",");
            }
        }

        private int findInsertCommaPos(int pos) throws Exception {
            char c;
            --pos;
            Document d = this.doc;
            while (pos >= 0 && Character.isWhitespace(d.getChar(pos))) {
                --pos;
            }
            if (pos >= 0 && (c = d.getChar(pos)) == '}') {
                return pos + 1;
            }
            return -1;
        }

        private int insert(int insertAt, String str) throws Exception {
            this.doc.replace(insertAt, 0, str);
            return insertAt + str.length();
        }

        private int findLast(char toFind) throws Exception {
            Document d = this.doc;
            int pos = d.getLength() - 1;
            while (pos >= 0 && d.getChar(pos) != toFind) {
                --pos;
            }
            return pos;
        }

        private String getNewline() throws Exception {
            if (MetaDataManipulator.this.fNewline == null) {
                MetaDataManipulator.this.fNewline = this.doc.getDefaultLineDelimiter().toString();
            }
            return MetaDataManipulator.this.fNewline;
        }
    }
}

