/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.quickfix;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.ProblemFixer;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.completions.DocumentEdits;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;

public class ReplaceDeprecatedPropertyQuickfix
implements ICompletionProposal {
    public static ProblemFixer FIXER = (context, problem, proposals) -> {
        String replacement;
        PropertyInfo metadata = problem.getMetadata();
        if (metadata != null && (replacement = metadata.getDeprecationReplacement()) != null) {
            proposals.add(new ReplaceDeprecatedPropertyQuickfix(context, problem));
        }
    };
    private final SpringPropertyProblem problem;
    private DocumentEdits edits;

    public ReplaceDeprecatedPropertyQuickfix(QuickfixContext context, SpringPropertyProblem problem) {
        this.problem = problem;
        String replacement = this.getReplacementProperty();
        this.edits = new DocumentEdits(context.getDocument());
        int start = problem.getOffset();
        int end = start + problem.getLength();
        this.edits.delete(start, end);
        this.edits.insert(start, replacement);
    }

    public void apply(IDocument doc) {
        try {
            this.edits.apply(doc);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private String getReplacementProperty() {
        return this.problem.getMetadata().getDeprecationReplacement();
    }

    public Point getSelection(IDocument doc) {
        try {
            return this.edits.getSelection(doc);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "Change to '" + this.getReplacementProperty() + "'";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

