/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.quickfix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.DefaultQuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemAnnotation;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;

public class SpringPropertyProblemQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[]{new NoCompletionsProposal()};
    private IPreferenceStore preferences;
    private UserInteractions ui;

    public SpringPropertyProblemQuickAssistProcessor(IPreferenceStore preferences, UserInteractions ui) {
        this.preferences = preferences;
        this.ui = ui;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer != null ? viewer.getSelectedRange().y : -1;
        TextInvocationContext context = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return NO_PROPOSALS;
        }
        List<ICompletionProposal> proposals = this.computeProposals((IQuickAssistInvocationContext)context, model);
        if (proposals.isEmpty()) {
            return NO_PROPOSALS;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private List<ICompletionProposal> computeProposals(IQuickAssistInvocationContext context, IAnnotationModel model) {
        int offset = context.getOffset();
        ArrayList<ReconcileProblem> annotationList = new ArrayList<ReconcileProblem>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            this.collectionProblems(annotation, annotationList);
        }
        SpringPropertyProblem[] problems = annotationList.toArray(new SpringPropertyProblem[annotationList.size()]);
        return this.computeProposals(context, problems);
    }

    private void collectionProblems(Annotation annotation, ArrayList<ReconcileProblem> annotationList) {
        if (annotation instanceof ReconcileProblemAnnotation) {
            annotationList.add(((ReconcileProblemAnnotation)annotation).getSpringPropertyProblem());
        }
    }

    private List<ICompletionProposal> computeProposals(IQuickAssistInvocationContext context, SpringPropertyProblem[] problems) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        SpringPropertyProblem[] springPropertyProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            SpringPropertyProblem problem = springPropertyProblemArray[n2];
            proposals.addAll(problem.getQuickfixes((QuickfixContext)new DefaultQuickfixContext("org.springframework.ide.eclipse.boot.properties.editor", this.preferences, context.getSourceViewer(), this.ui)));
            ++n2;
        }
        return proposals;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return annotation instanceof ReconcileProblemAnnotation && !annotation.isMarkedDeleted();
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }
}

