/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.MetaDataManipulator;
import org.springframework.ide.eclipse.boot.util.JavaProjectUtil;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class CreateAdditionalMetadataQuickfix
implements ICompletionProposal {
    private static final IPath METADATA_PATH = new Path("META-INF/additional-spring-configuration-metadata.json");
    private IJavaProject project;
    private String missingPropertyKey;
    private UserInteractions ui;

    public CreateAdditionalMetadataQuickfix(IJavaProject project, String missingProperty, UserInteractions ui) {
        Assert.isNotNull((Object)ui);
        this.project = project;
        this.missingPropertyKey = missingProperty;
        this.ui = ui;
    }

    public void apply(IDocument document) {
        try {
            IFile file = this.getMetadataFile(this.project);
            if (file != null) {
                this.addDefaultMetadataTo(file);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    private IFile getMetadataFile(IJavaProject project) {
        try {
            IContainer srcRoot;
            boolean includeDerived = false;
            IContainer[] srcRoots = JavaProjectUtil.getSourceFolders((IJavaProject)project, (boolean)includeDerived);
            IFile file = this.findExistingMetadataFile(srcRoots);
            if (file == null && (srcRoot = this.chooseSourceFolder(srcRoots)) != null) {
                file = this.createMetadataFile(srcRoot);
            }
            return file;
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return null;
        }
    }

    private IFile createMetadataFile(IContainer srcRoot) throws CoreException {
        IFile toCreate = srcRoot.getFile(METADATA_PATH);
        this.createFolder(toCreate.getParent());
        toCreate.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        return toCreate;
    }

    private void createFolder(IContainer container) throws CoreException {
        if (!container.exists()) {
            if (container instanceof IFolder) {
                IFolder folder = (IFolder)container;
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                throw ExceptionUtil.coreException((String)("Can't create folder '" + container + "': not a IFolder instance"));
            }
        }
    }

    private IContainer chooseSourceFolder(IContainer[] srcRoots) {
        if (srcRoots.length == 1) {
            return srcRoots[0];
        }
        if (srcRoots.length > 1) {
            return this.ui.chooseOneSourceFolder("Create Metadata File?", "No existing metadata file found. Choose a source folder to create one.", srcRoots, this.getPreferredSourceFolder(srcRoots));
        }
        return null;
    }

    private IContainer getPreferredSourceFolder(IContainer[] srcRoots) {
        IContainer[] iContainerArray = srcRoots;
        int n = srcRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer f = iContainerArray[n2];
            if ("resources".equals(f.getFullPath().lastSegment())) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    private void addDefaultMetadataTo(IFile file) throws Exception {
        MetaDataManipulator metadata = new MetaDataManipulator(file);
        if (!metadata.isReliable()) {
            this.ui.error("Failed to add metadata!", "'" + file.getFullPath() + "' does not appear to contain valid JSON!\n");
        } else {
            metadata.addDefaultInfo(this.missingPropertyKey);
            metadata.save();
        }
    }

    private IFile findExistingMetadataFile(IContainer[] srcRoots) {
        IContainer[] iContainerArray = srcRoots;
        int n = srcRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer srcFolder = iContainerArray[n2];
            IFile file = srcFolder.getFile(METADATA_PATH);
            if (file.exists()) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "Add property '" + this.missingPropertyKey + "' to the 'additional-spring-configuration-metadata.json' file" + " in project '" + this.getProjectName() + "'";
    }

    private String getProjectName() {
        return this.project.getProject().getName();
    }

    public String getDisplayString() {
        return "Create metadata for '" + this.missingPropertyKey + "'.";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

